<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfflinePaymentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains instructions from the Seller relating to an intent to pay using other payment capabilities 'offline' from EASD data exchange. For example, by use of an airline payment gateway.
 * @subpackage Structs
 */
class OfflinePaymentType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The payment method type. Examples: Credit Card, Cash. | The form of payment type. Examples: Credit Card, Cash. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Form of payment identification{/codeListName}
     * {codeListIdentifier}9888{/codeListIdentifier} | Additional BDT to specify payment method code.
     * - base: PaymentMethodCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The PayerReturnURI
     * Meta information extracted from the WSDL
     * - documentation: Contains Seller instructions for the Airline so that a payer can be returned to the sellers domain after payment. | A string of characters used to identify a resource. Such identification enables interaction with representations of
     * the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerReturnURI;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case FOID is a
     * Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The RedirectionAcceptanceInd
     * Meta information extracted from the WSDL
     * - documentation: Set to 'true' if Customer intends to accept paying via redirect and needs the airline to return a URI for payment redirection. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of
     * a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RedirectionAcceptanceInd;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * Constructor method for OfflinePaymentType
     * @uses OfflinePaymentType::setPaymentTypeCode()
     * @uses OfflinePaymentType::setPayerReturnURI()
     * @uses OfflinePaymentType::setPaymentBrandCode()
     * @uses OfflinePaymentType::setRedirectionAcceptanceInd()
     * @uses OfflinePaymentType::setRemark()
     * @param string $paymentTypeCode
     * @param string $payerReturnURI
     * @param string $paymentBrandCode
     * @param bool $redirectionAcceptanceInd
     * @param \StructType\RemarkType[] $remark
     */
    public function __construct($paymentTypeCode = null, $payerReturnURI = null, $paymentBrandCode = null, $redirectionAcceptanceInd = null, array $remark = array())
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setPayerReturnURI($payerReturnURI)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setRedirectionAcceptanceInd($redirectionAcceptanceInd)
            ->setRemark($remark);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\OfflinePaymentType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get PayerReturnURI value
     * @return string|null
     */
    public function getPayerReturnURI()
    {
        return $this->PayerReturnURI;
    }
    /**
     * Set PayerReturnURI value
     * @param string $payerReturnURI
     * @return \StructType\OfflinePaymentType
     */
    public function setPayerReturnURI($payerReturnURI = null)
    {
        // validation for constraint: string
        if (!is_null($payerReturnURI) && !is_string($payerReturnURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerReturnURI, true), gettype($payerReturnURI)), __LINE__);
        }
        $this->PayerReturnURI = $payerReturnURI;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\OfflinePaymentType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($paymentBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($paymentBrandCode, true)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get RedirectionAcceptanceInd value
     * @return bool|null
     */
    public function getRedirectionAcceptanceInd()
    {
        return $this->RedirectionAcceptanceInd;
    }
    /**
     * Set RedirectionAcceptanceInd value
     * @param bool $redirectionAcceptanceInd
     * @return \StructType\OfflinePaymentType
     */
    public function setRedirectionAcceptanceInd($redirectionAcceptanceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($redirectionAcceptanceInd) && !is_bool($redirectionAcceptanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redirectionAcceptanceInd, true), gettype($redirectionAcceptanceInd)), __LINE__);
        }
        $this->RedirectionAcceptanceInd = $redirectionAcceptanceInd;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offlinePaymentTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$offlinePaymentTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($offlinePaymentTypeRemarkItem) ? get_class($offlinePaymentTypeRemarkItem) : sprintf('%s(%s)', gettype($offlinePaymentTypeRemarkItem), var_export($offlinePaymentTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\OfflinePaymentType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\OfflinePaymentType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
