<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfflinePaymentInstructionReceiptType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains instructions from the Airline relating to payment using other payment capabilities 'offline' from EASD data exchange. For example, by use of an airline payment gateway.
 * @subpackage Structs
 */
class OfflinePaymentInstructionReceiptType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Type code assigned according to ATS Codeset PAYT. Example VI for Visa Card | The form of payment type. Examples: Credit Card, Cash. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Form of payment
     * identification{/codeListName} {codeListIdentifier}9888{/codeListIdentifier} | Additional BDT to specify payment method code.
     * - base: PaymentMethodCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Brand Code assigned according to ATS Codeset PAYB. Example CC for Customer Card | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case
     * FOID is a Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The PaymentGatewayURI
     * Meta information extracted from the WSDL
     * - documentation: Contains instructions for the seller so that a payer can go to the airline payment gateway. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a
     * network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentGatewayURI;
    /**
     * Constructor method for OfflinePaymentInstructionReceiptType
     * @uses OfflinePaymentInstructionReceiptType::setPaymentTypeCode()
     * @uses OfflinePaymentInstructionReceiptType::setPaymentBrandCode()
     * @uses OfflinePaymentInstructionReceiptType::setPaymentGatewayURI()
     * @param string $paymentTypeCode
     * @param string $paymentBrandCode
     * @param string $paymentGatewayURI
     */
    public function __construct($paymentTypeCode = null, $paymentBrandCode = null, $paymentGatewayURI = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setPaymentGatewayURI($paymentGatewayURI);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\OfflinePaymentInstructionReceiptType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\OfflinePaymentInstructionReceiptType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($paymentBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($paymentBrandCode, true)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get PaymentGatewayURI value
     * @return string|null
     */
    public function getPaymentGatewayURI()
    {
        return $this->PaymentGatewayURI;
    }
    /**
     * Set PaymentGatewayURI value
     * @param string $paymentGatewayURI
     * @return \StructType\OfflinePaymentInstructionReceiptType
     */
    public function setPaymentGatewayURI($paymentGatewayURI = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGatewayURI) && !is_string($paymentGatewayURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentGatewayURI, true), gettype($paymentGatewayURI)), __LINE__);
        }
        $this->PaymentGatewayURI = $paymentGatewayURI;
        return $this;
    }
}
