<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferedServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
 * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class OfferedServiceType extends AbstractStructBase
{
    /**
     * The OfferServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Offer Service Association
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OfferServiceAssociationType
     */
    public $OfferServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The InventoryGuaranteeDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time inventory against a given Service is guaranteed. If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed. Notes: The presence of an
     * inventory guarantee does not assume a guarantee of price. For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present. The assumption is that inventory is held when an Order is created (or changed),
     * so this time limit only applies in the context of an Offer. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InventoryGuaranteeDateTime;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Offered Service Status instance. See ATSB Codeset OfferedService for possible values. | The possible statuses of an Offered Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Offer Service
     * Status, coded{/codeListName} {codeListIdentifier}OFFEREDSERVICE{/codeListIdentifier} | Core statuses for Offer Service to be used across Enhanced and Simplified Distribution Standards, refer to IATA code set Offer Service
     * - base: OfferedServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for OfferedServiceType
     * @uses OfferedServiceType::setOfferServiceAssociation()
     * @uses OfferedServiceType::setPaxRefID()
     * @uses OfferedServiceType::setServiceID()
     * @uses OfferedServiceType::setAirlineTaxonomy()
     * @uses OfferedServiceType::setDescText()
     * @uses OfferedServiceType::setInventoryGuaranteeDateTime()
     * @uses OfferedServiceType::setRichMedia()
     * @uses OfferedServiceType::setServiceRefID()
     * @uses OfferedServiceType::setStatusCode()
     * @uses OfferedServiceType::setValidatingCarrier()
     * @param \StructType\OfferServiceAssociationType $offerServiceAssociation
     * @param string[] $paxRefID
     * @param string $serviceID
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param string $descText
     * @param string $inventoryGuaranteeDateTime
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param string $serviceRefID
     * @param string $statusCode
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct(\StructType\OfferServiceAssociationType $offerServiceAssociation = null, array $paxRefID = array(), $serviceID = null, array $airlineTaxonomy = array(), $descText = null, $inventoryGuaranteeDateTime = null, array $richMedia = array(), $serviceRefID = null, $statusCode = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setOfferServiceAssociation($offerServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setServiceID($serviceID)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setDescText($descText)
            ->setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime)
            ->setRichMedia($richMedia)
            ->setServiceRefID($serviceRefID)
            ->setStatusCode($statusCode)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get OfferServiceAssociation value
     * @return \StructType\OfferServiceAssociationType
     */
    public function getOfferServiceAssociation()
    {
        return $this->OfferServiceAssociation;
    }
    /**
     * Set OfferServiceAssociation value
     * @param \StructType\OfferServiceAssociationType $offerServiceAssociation
     * @return \StructType\OfferedServiceType
     */
    public function setOfferServiceAssociation(\StructType\OfferServiceAssociationType $offerServiceAssociation = null)
    {
        $this->OfferServiceAssociation = $offerServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offeredServiceTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($offeredServiceTypePaxRefIDItem)) {
                $invalidValues[] = is_object($offeredServiceTypePaxRefIDItem) ? get_class($offeredServiceTypePaxRefIDItem) : sprintf('%s(%s)', gettype($offeredServiceTypePaxRefIDItem), var_export($offeredServiceTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\OfferedServiceType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OfferedServiceType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\OfferedServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offeredServiceTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$offeredServiceTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($offeredServiceTypeAirlineTaxonomyItem) ? get_class($offeredServiceTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($offeredServiceTypeAirlineTaxonomyItem), var_export($offeredServiceTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\OfferedServiceType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\OfferedServiceType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\OfferedServiceType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get InventoryGuaranteeDateTime value
     * @return string|null
     */
    public function getInventoryGuaranteeDateTime()
    {
        return $this->InventoryGuaranteeDateTime;
    }
    /**
     * Set InventoryGuaranteeDateTime value
     * @param string $inventoryGuaranteeDateTime
     * @return \StructType\OfferedServiceType
     */
    public function setInventoryGuaranteeDateTime($inventoryGuaranteeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryGuaranteeDateTime) && !is_string($inventoryGuaranteeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryGuaranteeDateTime, true), gettype($inventoryGuaranteeDateTime)), __LINE__);
        }
        $this->InventoryGuaranteeDateTime = $inventoryGuaranteeDateTime;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offeredServiceTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$offeredServiceTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($offeredServiceTypeRichMediaItem) ? get_class($offeredServiceTypeRichMediaItem) : sprintf('%s(%s)', gettype($offeredServiceTypeRichMediaItem), var_export($offeredServiceTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\OfferedServiceType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\OfferedServiceType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\OfferedServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\OfferedServiceType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\OfferedServiceType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
