<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferPenaltyInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: list of Offer Penalty Information.
 * @subpackage Structs
 */
class OfferPenaltyInfoListType extends AbstractStructBase
{
    /**
     * The PenaltyInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to a penalty applied to an OfferItem for the requested servicing operations.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OfferPenaltyInfoType[]
     */
    public $PenaltyInfo;
    /**
     * Constructor method for OfferPenaltyInfoListType
     * @uses OfferPenaltyInfoListType::setPenaltyInfo()
     * @param \StructType\OfferPenaltyInfoType[] $penaltyInfo
     */
    public function __construct(array $penaltyInfo = array())
    {
        $this
            ->setPenaltyInfo($penaltyInfo);
    }
    /**
     * Get PenaltyInfo value
     * @return \StructType\OfferPenaltyInfoType[]
     */
    public function getPenaltyInfo()
    {
        return $this->PenaltyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerPenaltyInfoListTypePenaltyInfoItem) {
            // validation for constraint: itemType
            if (!$offerPenaltyInfoListTypePenaltyInfoItem instanceof \StructType\OfferPenaltyInfoType) {
                $invalidValues[] = is_object($offerPenaltyInfoListTypePenaltyInfoItem) ? get_class($offerPenaltyInfoListTypePenaltyInfoItem) : sprintf('%s(%s)', gettype($offerPenaltyInfoListTypePenaltyInfoItem), var_export($offerPenaltyInfoListTypePenaltyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyInfo property can only contain items of type \StructType\OfferPenaltyInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferPenaltyInfoType[] $penaltyInfo
     * @return \StructType\OfferPenaltyInfoListType
     */
    public function setPenaltyInfo(array $penaltyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyInfoArrayErrorMessage = self::validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo($penaltyInfo))) {
            throw new \InvalidArgumentException($penaltyInfoArrayErrorMessage, __LINE__);
        }
        $this->PenaltyInfo = $penaltyInfo;
        return $this;
    }
    /**
     * Add item to PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferPenaltyInfoType $item
     * @return \StructType\OfferPenaltyInfoListType
     */
    public function addToPenaltyInfo(\StructType\OfferPenaltyInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferPenaltyInfoType) {
            throw new \InvalidArgumentException(sprintf('The PenaltyInfo property can only contain items of type \StructType\OfferPenaltyInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyInfo[] = $item;
        return $this;
    }
}
