<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferItemTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer Item type used for long sell transactions
 * @subpackage Structs
 */
class OfferItemTypeType extends AbstractStructBase
{
    /**
     * The BaggageItem
     * Meta information extracted from the WSDL
     * - documentation: Baggage service information used for long sells.
     * - choice: BaggageItem | FlightItem | OtherItem | SeatItem
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BaggageItemType
     */
    public $BaggageItem;
    /**
     * The FlightItem
     * Meta information extracted from the WSDL
     * - documentation: Flight service information used for long sells.
     * - choice: BaggageItem | FlightItem | OtherItem | SeatItem
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FlightItemType
     */
    public $FlightItem;
    /**
     * The OtherItem
     * Meta information extracted from the WSDL
     * - documentation: Other service information used for long sells.
     * - choice: BaggageItem | FlightItem | OtherItem | SeatItem
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OtherItemType
     */
    public $OtherItem;
    /**
     * The SeatItem
     * Meta information extracted from the WSDL
     * - documentation: Seat service information used for long sells.
     * - choice: BaggageItem | FlightItem | OtherItem | SeatItem
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatItemType
     */
    public $SeatItem;
    /**
     * Constructor method for OfferItemTypeType
     * @uses OfferItemTypeType::setBaggageItem()
     * @uses OfferItemTypeType::setFlightItem()
     * @uses OfferItemTypeType::setOtherItem()
     * @uses OfferItemTypeType::setSeatItem()
     * @param \StructType\BaggageItemType $baggageItem
     * @param \StructType\FlightItemType $flightItem
     * @param \StructType\OtherItemType $otherItem
     * @param \StructType\SeatItemType $seatItem
     */
    public function __construct(\StructType\BaggageItemType $baggageItem = null, \StructType\FlightItemType $flightItem = null, \StructType\OtherItemType $otherItem = null, \StructType\SeatItemType $seatItem = null)
    {
        $this
            ->setBaggageItem($baggageItem)
            ->setFlightItem($flightItem)
            ->setOtherItem($otherItem)
            ->setSeatItem($seatItem);
    }
    /**
     * Get BaggageItem value
     * @return \StructType\BaggageItemType
     */
    public function getBaggageItem()
    {
        return isset($this->BaggageItem) ? $this->BaggageItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBaggageItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBaggageItemForChoiceConstraintsFromSetBaggageItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FlightItem',
            'OtherItem',
            'SeatItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BaggageItem can\'t be set as the property %s is already set. Only one property must be set among these properties: BaggageItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BaggageItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageItemType $baggageItem
     * @return \StructType\OfferItemTypeType
     */
    public function setBaggageItem(\StructType\BaggageItemType $baggageItem = null)
    {
        // validation for constraint: choice(BaggageItem, FlightItem, OtherItem, SeatItem)
        if ('' !== ($baggageItemChoiceErrorMessage = self::validateBaggageItemForChoiceConstraintsFromSetBaggageItem($baggageItem))) {
            throw new \InvalidArgumentException($baggageItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($baggageItem) || (is_array($baggageItem) && empty($baggageItem))) {
            unset($this->BaggageItem);
        } else {
            $this->BaggageItem = $baggageItem;
        }
        return $this;
    }
    /**
     * Get FlightItem value
     * @return \StructType\FlightItemType
     */
    public function getFlightItem()
    {
        return isset($this->FlightItem) ? $this->FlightItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlightItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlightItemForChoiceConstraintsFromSetFlightItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BaggageItem',
            'OtherItem',
            'SeatItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlightItem can\'t be set as the property %s is already set. Only one property must be set among these properties: FlightItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlightItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FlightItemType $flightItem
     * @return \StructType\OfferItemTypeType
     */
    public function setFlightItem(\StructType\FlightItemType $flightItem = null)
    {
        // validation for constraint: choice(BaggageItem, FlightItem, OtherItem, SeatItem)
        if ('' !== ($flightItemChoiceErrorMessage = self::validateFlightItemForChoiceConstraintsFromSetFlightItem($flightItem))) {
            throw new \InvalidArgumentException($flightItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($flightItem) || (is_array($flightItem) && empty($flightItem))) {
            unset($this->FlightItem);
        } else {
            $this->FlightItem = $flightItem;
        }
        return $this;
    }
    /**
     * Get OtherItem value
     * @return \StructType\OtherItemType
     */
    public function getOtherItem()
    {
        return isset($this->OtherItem) ? $this->OtherItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOtherItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOtherItemForChoiceConstraintsFromSetOtherItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BaggageItem',
            'FlightItem',
            'SeatItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OtherItem can\'t be set as the property %s is already set. Only one property must be set among these properties: OtherItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OtherItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtherItemType $otherItem
     * @return \StructType\OfferItemTypeType
     */
    public function setOtherItem(\StructType\OtherItemType $otherItem = null)
    {
        // validation for constraint: choice(BaggageItem, FlightItem, OtherItem, SeatItem)
        if ('' !== ($otherItemChoiceErrorMessage = self::validateOtherItemForChoiceConstraintsFromSetOtherItem($otherItem))) {
            throw new \InvalidArgumentException($otherItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($otherItem) || (is_array($otherItem) && empty($otherItem))) {
            unset($this->OtherItem);
        } else {
            $this->OtherItem = $otherItem;
        }
        return $this;
    }
    /**
     * Get SeatItem value
     * @return \StructType\SeatItemType
     */
    public function getSeatItem()
    {
        return isset($this->SeatItem) ? $this->SeatItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatItemForChoiceConstraintsFromSetSeatItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BaggageItem',
            'FlightItem',
            'OtherItem',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatItem can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatItemType $seatItem
     * @return \StructType\OfferItemTypeType
     */
    public function setSeatItem(\StructType\SeatItemType $seatItem = null)
    {
        // validation for constraint: choice(BaggageItem, FlightItem, OtherItem, SeatItem)
        if ('' !== ($seatItemChoiceErrorMessage = self::validateSeatItemForChoiceConstraintsFromSetSeatItem($seatItem))) {
            throw new \InvalidArgumentException($seatItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatItem) || (is_array($seatItem) && empty($seatItem))) {
            unset($this->SeatItem);
        } else {
            $this->SeatItem = $seatItem;
        }
        return $this;
    }
}
