<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferItemTypeCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filters results based on offer Item Type code
 * @subpackage Structs
 */
class OfferItemTypeCriteriaType extends AbstractStructBase
{
    /**
     * The OfferItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Offer Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemTypeCode;
    /**
     * Constructor method for OfferItemTypeCriteriaType
     * @uses OfferItemTypeCriteriaType::setOfferItemTypeCode()
     * @param string $offerItemTypeCode
     */
    public function __construct($offerItemTypeCode = null)
    {
        $this
            ->setOfferItemTypeCode($offerItemTypeCode);
    }
    /**
     * Get OfferItemTypeCode value
     * @return string|null
     */
    public function getOfferItemTypeCode()
    {
        return $this->OfferItemTypeCode;
    }
    /**
     * Set OfferItemTypeCode value
     * @param string $offerItemTypeCode
     * @return \StructType\OfferItemTypeCriteriaType
     */
    public function setOfferItemTypeCode($offerItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemTypeCode) && !is_string($offerItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemTypeCode, true), gettype($offerItemTypeCode)), __LINE__);
        }
        $this->OfferItemTypeCode = $offerItemTypeCode;
        return $this;
    }
}
