<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferFilterCriteriawithOriginandDestType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of filter criteria based on offer preferences/criteria. Technical specialized to use just origin and destination points.
 * @subpackage Structs
 */
class OfferFilterCriteriawithOriginandDestType extends AbstractStructBase
{
    /**
     * The DirectionalIndText
     * Meta information extracted from the WSDL
     * - documentation: 1 = From LOC 1 to LOC 2 2 = To LOC 1 from LOC 2 3 = Both | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DirectionalIndText;
    /**
     * The OfferDestPoint
     * Meta information extracted from the WSDL
     * - documentation: Criteria used to filter results based on geographic preferences, including Area, State, City, Airport, or Geospatial information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GeographicFilterCriteriaType
     */
    public $OfferDestPoint;
    /**
     * The OfferOriginPoint
     * Meta information extracted from the WSDL
     * - documentation: Criteria used to filter results based on geographic preferences, including Area, State, City, Airport, or Geospatial information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GeographicFilterCriteriaType
     */
    public $OfferOriginPoint;
    /**
     * Constructor method for OfferFilterCriteriawithOriginandDestType
     * @uses OfferFilterCriteriawithOriginandDestType::setDirectionalIndText()
     * @uses OfferFilterCriteriawithOriginandDestType::setOfferDestPoint()
     * @uses OfferFilterCriteriawithOriginandDestType::setOfferOriginPoint()
     * @param string $directionalIndText
     * @param \StructType\GeographicFilterCriteriaType $offerDestPoint
     * @param \StructType\GeographicFilterCriteriaType $offerOriginPoint
     */
    public function __construct($directionalIndText = null, \StructType\GeographicFilterCriteriaType $offerDestPoint = null, \StructType\GeographicFilterCriteriaType $offerOriginPoint = null)
    {
        $this
            ->setDirectionalIndText($directionalIndText)
            ->setOfferDestPoint($offerDestPoint)
            ->setOfferOriginPoint($offerOriginPoint);
    }
    /**
     * Get DirectionalIndText value
     * @return string
     */
    public function getDirectionalIndText()
    {
        return $this->DirectionalIndText;
    }
    /**
     * Set DirectionalIndText value
     * @param string $directionalIndText
     * @return \StructType\OfferFilterCriteriawithOriginandDestType
     */
    public function setDirectionalIndText($directionalIndText = null)
    {
        // validation for constraint: string
        if (!is_null($directionalIndText) && !is_string($directionalIndText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directionalIndText, true), gettype($directionalIndText)), __LINE__);
        }
        $this->DirectionalIndText = $directionalIndText;
        return $this;
    }
    /**
     * Get OfferDestPoint value
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function getOfferDestPoint()
    {
        return $this->OfferDestPoint;
    }
    /**
     * Set OfferDestPoint value
     * @param \StructType\GeographicFilterCriteriaType $offerDestPoint
     * @return \StructType\OfferFilterCriteriawithOriginandDestType
     */
    public function setOfferDestPoint(\StructType\GeographicFilterCriteriaType $offerDestPoint = null)
    {
        $this->OfferDestPoint = $offerDestPoint;
        return $this;
    }
    /**
     * Get OfferOriginPoint value
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function getOfferOriginPoint()
    {
        return $this->OfferOriginPoint;
    }
    /**
     * Set OfferOriginPoint value
     * @param \StructType\GeographicFilterCriteriaType $offerOriginPoint
     * @return \StructType\OfferFilterCriteriawithOriginandDestType
     */
    public function setOfferOriginPoint(\StructType\GeographicFilterCriteriaType $offerOriginPoint = null)
    {
        $this->OfferOriginPoint = $offerOriginPoint;
        return $this;
    }
}
