<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A priced grouping of one or more services within an Offer. The New Offer Item assigns a total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
 * @subpackage Structs
 */
class NewOfferItemType extends AbstractStructBase
{
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. Exceeding 64 characters or use of dashes is not recommended. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Offered Service is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold
     * to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OfferedServiceType[]
     */
    public $Service;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The ModificationProhibitedInd
     * Meta information extracted from the WSDL
     * - documentation: POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POA's offer ARE
     * NOT allowed. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModificationProhibitedInd;
    /**
     * The OfferItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Offer Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemTypeCode;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaymentTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: Payment Time Limit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentTimeLimitType
     */
    public $PaymentTimeLimit;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an offer item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either a new shopping process should
     * begin, or the offer should be repriced resulting in a new Offer. Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item. At Order creation (or change)
     * the airline can increase the remaining length of time beyond the original time limit should they wish to. Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline. | A date time
     * identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The StopOverRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Additional information supplied by the Airline for the current Itinerary to advise the Seller that additional options could be available (if the Seller changes the request) to add Stop Overs within the itinerary.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StopOverRestrictionsType
     */
    public $StopOverRestrictions;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for NewOfferItemType
     * @uses NewOfferItemType::setOfferItemID()
     * @uses NewOfferItemType::setPrice()
     * @uses NewOfferItemType::setService()
     * @uses NewOfferItemType::setAirlineTaxonomy()
     * @uses NewOfferItemType::setCancelRestrictions()
     * @uses NewOfferItemType::setChangeRestrictions()
     * @uses NewOfferItemType::setCommission()
     * @uses NewOfferItemType::setDesc()
     * @uses NewOfferItemType::setFareDetail()
     * @uses NewOfferItemType::setMandatoryInd()
     * @uses NewOfferItemType::setModificationProhibitedInd()
     * @uses NewOfferItemType::setOfferItemTypeCode()
     * @uses NewOfferItemType::setOwnerCode()
     * @uses NewOfferItemType::setPaymentTimeLimit()
     * @uses NewOfferItemType::setPriceGuaranteeTimeLimitDateTime()
     * @uses NewOfferItemType::setRichMedia()
     * @uses NewOfferItemType::setStopOverRestrictions()
     * @uses NewOfferItemType::setWebAddressURI()
     * @param string $offerItemID
     * @param \StructType\PriceType $price
     * @param \StructType\OfferedServiceType[] $service
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\DescType[] $desc
     * @param \StructType\FareDetailType[] $fareDetail
     * @param bool $mandatoryInd
     * @param bool $modificationProhibitedInd
     * @param string $offerItemTypeCode
     * @param string $ownerCode
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @param string $priceGuaranteeTimeLimitDateTime
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param \StructType\StopOverRestrictionsType $stopOverRestrictions
     * @param string $webAddressURI
     */
    public function __construct($offerItemID = null, \StructType\PriceType $price = null, array $service = array(), array $airlineTaxonomy = array(), array $cancelRestrictions = array(), array $changeRestrictions = array(), array $commission = array(), array $desc = array(), array $fareDetail = array(), $mandatoryInd = null, $modificationProhibitedInd = null, $offerItemTypeCode = null, $ownerCode = null, \StructType\PaymentTimeLimitType $paymentTimeLimit = null, $priceGuaranteeTimeLimitDateTime = null, array $richMedia = array(), \StructType\StopOverRestrictionsType $stopOverRestrictions = null, $webAddressURI = null)
    {
        $this
            ->setOfferItemID($offerItemID)
            ->setPrice($price)
            ->setService($service)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCommission($commission)
            ->setDesc($desc)
            ->setFareDetail($fareDetail)
            ->setMandatoryInd($mandatoryInd)
            ->setModificationProhibitedInd($modificationProhibitedInd)
            ->setOfferItemTypeCode($offerItemTypeCode)
            ->setOwnerCode($ownerCode)
            ->setPaymentTimeLimit($paymentTimeLimit)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime)
            ->setRichMedia($richMedia)
            ->setStopOverRestrictions($stopOverRestrictions)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\NewOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\NewOfferItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\OfferedServiceType[]
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeServiceItem instanceof \StructType\OfferedServiceType) {
                $invalidValues[] = is_object($newOfferItemTypeServiceItem) ? get_class($newOfferItemTypeServiceItem) : sprintf('%s(%s)', gettype($newOfferItemTypeServiceItem), var_export($newOfferItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\OfferedServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferedServiceType[] $service
     * @return \StructType\NewOfferItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferedServiceType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToService(\StructType\OfferedServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferedServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\OfferedServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($newOfferItemTypeAirlineTaxonomyItem) ? get_class($newOfferItemTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($newOfferItemTypeAirlineTaxonomyItem), var_export($newOfferItemTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\NewOfferItemType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($newOfferItemTypeCancelRestrictionsItem) ? get_class($newOfferItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($newOfferItemTypeCancelRestrictionsItem), var_export($newOfferItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\NewOfferItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($newOfferItemTypeChangeRestrictionsItem) ? get_class($newOfferItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($newOfferItemTypeChangeRestrictionsItem), var_export($newOfferItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\NewOfferItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($newOfferItemTypeCommissionItem) ? get_class($newOfferItemTypeCommissionItem) : sprintf('%s(%s)', gettype($newOfferItemTypeCommissionItem), var_export($newOfferItemTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\NewOfferItemType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeDescItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($newOfferItemTypeDescItem) ? get_class($newOfferItemTypeDescItem) : sprintf('%s(%s)', gettype($newOfferItemTypeDescItem), var_export($newOfferItemTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\NewOfferItemType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($newOfferItemTypeFareDetailItem) ? get_class($newOfferItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($newOfferItemTypeFareDetailItem), var_export($newOfferItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\NewOfferItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\NewOfferItemType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get ModificationProhibitedInd value
     * @return bool|null
     */
    public function getModificationProhibitedInd()
    {
        return $this->ModificationProhibitedInd;
    }
    /**
     * Set ModificationProhibitedInd value
     * @param bool $modificationProhibitedInd
     * @return \StructType\NewOfferItemType
     */
    public function setModificationProhibitedInd($modificationProhibitedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modificationProhibitedInd) && !is_bool($modificationProhibitedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modificationProhibitedInd, true), gettype($modificationProhibitedInd)), __LINE__);
        }
        $this->ModificationProhibitedInd = $modificationProhibitedInd;
        return $this;
    }
    /**
     * Get OfferItemTypeCode value
     * @return string|null
     */
    public function getOfferItemTypeCode()
    {
        return $this->OfferItemTypeCode;
    }
    /**
     * Set OfferItemTypeCode value
     * @param string $offerItemTypeCode
     * @return \StructType\NewOfferItemType
     */
    public function setOfferItemTypeCode($offerItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemTypeCode) && !is_string($offerItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemTypeCode, true), gettype($offerItemTypeCode)), __LINE__);
        }
        $this->OfferItemTypeCode = $offerItemTypeCode;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\NewOfferItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaymentTimeLimit value
     * @return \StructType\PaymentTimeLimitType|null
     */
    public function getPaymentTimeLimit()
    {
        return $this->PaymentTimeLimit;
    }
    /**
     * Set PaymentTimeLimit value
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @return \StructType\NewOfferItemType
     */
    public function setPaymentTimeLimit(\StructType\PaymentTimeLimitType $paymentTimeLimit = null)
    {
        $this->PaymentTimeLimit = $paymentTimeLimit;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\NewOfferItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newOfferItemTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$newOfferItemTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($newOfferItemTypeRichMediaItem) ? get_class($newOfferItemTypeRichMediaItem) : sprintf('%s(%s)', gettype($newOfferItemTypeRichMediaItem), var_export($newOfferItemTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\NewOfferItemType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\NewOfferItemType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get StopOverRestrictions value
     * @return \StructType\StopOverRestrictionsType|null
     */
    public function getStopOverRestrictions()
    {
        return $this->StopOverRestrictions;
    }
    /**
     * Set StopOverRestrictions value
     * @param \StructType\StopOverRestrictionsType $stopOverRestrictions
     * @return \StructType\NewOfferItemType
     */
    public function setStopOverRestrictions(\StructType\StopOverRestrictionsType $stopOverRestrictions = null)
    {
        $this->StopOverRestrictions = $stopOverRestrictions;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\NewOfferItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
