<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameChangeOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A priced grouping of one or more services within an Offer.
 * @subpackage Structs
 */
class NameChangeOfferItemType extends AbstractStructBase
{
    /**
     * The NameChangeService
     * Meta information extracted from the WSDL
     * - documentation: The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\NameChangeServiceType[]
     */
    public $NameChangeService;
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The ModificationProhibitedInd
     * Meta information extracted from the WSDL
     * - documentation: POA to ORA only: to indicate that the offer is non-modifiable. This indicates to ORA that its offer is non-modifiable (e.g. Regulatory or brand protection reasons). If indicator is set to TRUE, modifications to the POA's offer ARE
     * NOT allowed. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModificationProhibitedInd;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaxNameChange
     * Meta information extracted from the WSDL
     * - documentation: Echos back the name changes allowed by the Airline, packaged within an OfferItem.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxNameChangeType
     */
    public $PaxNameChange;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an offer item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either a new shopping process should
     * begin, or the offer should be repriced resulting in a new Offer. Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item. At Order creation (or change)
     * the airline can increase the remaining length of time beyond the original time limit should they wish to. Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline. | A date time
     * identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * Constructor method for NameChangeOfferItemType
     * @uses NameChangeOfferItemType::setNameChangeService()
     * @uses NameChangeOfferItemType::setOfferItemID()
     * @uses NameChangeOfferItemType::setPrice()
     * @uses NameChangeOfferItemType::setCancelRestrictions()
     * @uses NameChangeOfferItemType::setChangeRestrictions()
     * @uses NameChangeOfferItemType::setFareDetail()
     * @uses NameChangeOfferItemType::setMandatoryInd()
     * @uses NameChangeOfferItemType::setModificationProhibitedInd()
     * @uses NameChangeOfferItemType::setOwnerCode()
     * @uses NameChangeOfferItemType::setPaxNameChange()
     * @uses NameChangeOfferItemType::setPenaltyRefID()
     * @uses NameChangeOfferItemType::setPriceGuaranteeTimeLimitDateTime()
     * @param \StructType\NameChangeServiceType[] $nameChangeService
     * @param string $offerItemID
     * @param \StructType\PriceType $price
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\FareDetailType[] $fareDetail
     * @param bool $mandatoryInd
     * @param bool $modificationProhibitedInd
     * @param string $ownerCode
     * @param \StructType\PaxNameChangeType $paxNameChange
     * @param string[] $penaltyRefID
     * @param string $priceGuaranteeTimeLimitDateTime
     */
    public function __construct(array $nameChangeService = array(), $offerItemID = null, \StructType\PriceType $price = null, array $cancelRestrictions = array(), array $changeRestrictions = array(), array $fareDetail = array(), $mandatoryInd = null, $modificationProhibitedInd = null, $ownerCode = null, \StructType\PaxNameChangeType $paxNameChange = null, array $penaltyRefID = array(), $priceGuaranteeTimeLimitDateTime = null)
    {
        $this
            ->setNameChangeService($nameChangeService)
            ->setOfferItemID($offerItemID)
            ->setPrice($price)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setFareDetail($fareDetail)
            ->setMandatoryInd($mandatoryInd)
            ->setModificationProhibitedInd($modificationProhibitedInd)
            ->setOwnerCode($ownerCode)
            ->setPaxNameChange($paxNameChange)
            ->setPenaltyRefID($penaltyRefID)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime);
    }
    /**
     * Get NameChangeService value
     * @return \StructType\NameChangeServiceType[]
     */
    public function getNameChangeService()
    {
        return $this->NameChangeService;
    }
    /**
     * This method is responsible for validating the values passed to the setNameChangeService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameChangeService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameChangeServiceForArrayConstraintsFromSetNameChangeService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameChangeOfferItemTypeNameChangeServiceItem) {
            // validation for constraint: itemType
            if (!$nameChangeOfferItemTypeNameChangeServiceItem instanceof \StructType\NameChangeServiceType) {
                $invalidValues[] = is_object($nameChangeOfferItemTypeNameChangeServiceItem) ? get_class($nameChangeOfferItemTypeNameChangeServiceItem) : sprintf('%s(%s)', gettype($nameChangeOfferItemTypeNameChangeServiceItem), var_export($nameChangeOfferItemTypeNameChangeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameChangeService property can only contain items of type \StructType\NameChangeServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameChangeService value
     * @throws \InvalidArgumentException
     * @param \StructType\NameChangeServiceType[] $nameChangeService
     * @return \StructType\NameChangeOfferItemType
     */
    public function setNameChangeService(array $nameChangeService = array())
    {
        // validation for constraint: array
        if ('' !== ($nameChangeServiceArrayErrorMessage = self::validateNameChangeServiceForArrayConstraintsFromSetNameChangeService($nameChangeService))) {
            throw new \InvalidArgumentException($nameChangeServiceArrayErrorMessage, __LINE__);
        }
        $this->NameChangeService = $nameChangeService;
        return $this;
    }
    /**
     * Add item to NameChangeService value
     * @throws \InvalidArgumentException
     * @param \StructType\NameChangeServiceType $item
     * @return \StructType\NameChangeOfferItemType
     */
    public function addToNameChangeService(\StructType\NameChangeServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameChangeServiceType) {
            throw new \InvalidArgumentException(sprintf('The NameChangeService property can only contain items of type \StructType\NameChangeServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameChangeService[] = $item;
        return $this;
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\NameChangeOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\NameChangeOfferItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameChangeOfferItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$nameChangeOfferItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($nameChangeOfferItemTypeCancelRestrictionsItem) ? get_class($nameChangeOfferItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($nameChangeOfferItemTypeCancelRestrictionsItem), var_export($nameChangeOfferItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\NameChangeOfferItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\NameChangeOfferItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameChangeOfferItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$nameChangeOfferItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($nameChangeOfferItemTypeChangeRestrictionsItem) ? get_class($nameChangeOfferItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($nameChangeOfferItemTypeChangeRestrictionsItem), var_export($nameChangeOfferItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\NameChangeOfferItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\NameChangeOfferItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameChangeOfferItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$nameChangeOfferItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($nameChangeOfferItemTypeFareDetailItem) ? get_class($nameChangeOfferItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($nameChangeOfferItemTypeFareDetailItem), var_export($nameChangeOfferItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\NameChangeOfferItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\NameChangeOfferItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\NameChangeOfferItemType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get ModificationProhibitedInd value
     * @return bool|null
     */
    public function getModificationProhibitedInd()
    {
        return $this->ModificationProhibitedInd;
    }
    /**
     * Set ModificationProhibitedInd value
     * @param bool $modificationProhibitedInd
     * @return \StructType\NameChangeOfferItemType
     */
    public function setModificationProhibitedInd($modificationProhibitedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modificationProhibitedInd) && !is_bool($modificationProhibitedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modificationProhibitedInd, true), gettype($modificationProhibitedInd)), __LINE__);
        }
        $this->ModificationProhibitedInd = $modificationProhibitedInd;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\NameChangeOfferItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaxNameChange value
     * @return \StructType\PaxNameChangeType|null
     */
    public function getPaxNameChange()
    {
        return $this->PaxNameChange;
    }
    /**
     * Set PaxNameChange value
     * @param \StructType\PaxNameChangeType $paxNameChange
     * @return \StructType\NameChangeOfferItemType
     */
    public function setPaxNameChange(\StructType\PaxNameChangeType $paxNameChange = null)
    {
        $this->PaxNameChange = $paxNameChange;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameChangeOfferItemTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($nameChangeOfferItemTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($nameChangeOfferItemTypePenaltyRefIDItem) ? get_class($nameChangeOfferItemTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($nameChangeOfferItemTypePenaltyRefIDItem), var_export($nameChangeOfferItemTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\NameChangeOfferItemType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NameChangeOfferItemType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\NameChangeOfferItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
}
