<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NUCAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: Base Fare Amount as originally filed.
 * @subpackage Structs
 */
class NUCAmount extends AbstractStructBase
{
    /**
     * The _
     * @var int
     */
    public $_;
    /**
     * The ROE
     * Meta information extracted from the WSDL
     * - documentation: Applicable rate of exhange
     * @var string
     */
    public $ROE;
    /**
     * Constructor method for NUCAmount
     * @uses NUCAmount::set_()
     * @uses NUCAmount::setROE()
     * @param int $_
     * @param string $rOE
     */
    public function __construct($_ = null, $rOE = null)
    {
        $this
            ->set_($_)
            ->setROE($rOE);
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \StructType\NUCAmount
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !(is_int($_) || ctype_digit($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ROE value
     * @return string|null
     */
    public function getROE()
    {
        return $this->ROE;
    }
    /**
     * Set ROE value
     * @param string $rOE
     * @return \StructType\NUCAmount
     */
    public function setROE($rOE = null)
    {
        // validation for constraint: string
        if (!is_null($rOE) && !is_string($rOE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOE, true), gettype($rOE)), __LINE__);
        }
        $this->ROE = $rOE;
        return $this;
    }
}
