<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingName StructType
 * Meta information extracted from the WSDL
 * - documentation: Cabin Class Marketing Name. Example: Premium Economy | A data type for Proper Name size constraint.
 * - base: xs:string
 * - maxLength: 50
 * @subpackage Structs
 */
class MarketingName extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: A data type for Proper Name size constraint.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $_;
    /**
     * The CabinDesignator
     * Meta information extracted from the WSDL
     * - documentation: Designator code for the cabin. Example: Y
     * @var string
     */
    public $CabinDesignator;
    /**
     * Constructor method for MarketingName
     * @uses MarketingName::set_()
     * @uses MarketingName::setCabinDesignator()
     * @param string $_
     * @param string $cabinDesignator
     */
    public function __construct($_ = null, $cabinDesignator = null)
    {
        $this
            ->set_($_)
            ->setCabinDesignator($cabinDesignator);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\MarketingName
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($_) && mb_strlen($_) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CabinDesignator value
     * @return string|null
     */
    public function getCabinDesignator()
    {
        return $this->CabinDesignator;
    }
    /**
     * Set CabinDesignator value
     * @param string $cabinDesignator
     * @return \StructType\MarketingName
     */
    public function setCabinDesignator($cabinDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($cabinDesignator) && !is_string($cabinDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinDesignator, true), gettype($cabinDesignator)), __LINE__);
        }
        $this->CabinDesignator = $cabinDesignator;
        return $this;
    }
}
