<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyProgramAccountType StructType
 * Meta information extracted from the WSDL
 * - documentation: An account set up for a customer within a rewards program which holds funds on behalf of that customer.
 * @subpackage Structs
 */
class LoyaltyProgramAccountType extends AbstractStructBase
{
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - documentation: A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LoyaltyProgramType
     */
    public $LoyaltyProgram;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program account number. Example: ABC123456 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The SignInID
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program sign-in ID (or username). | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignInID;
    /**
     * The TierCode
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program tier code. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierCode;
    /**
     * The TierName
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program tier name. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierName;
    /**
     * The TierPriorityText
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierPriorityText;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club | A string of characters used to identify a resource. Such identification enables interaction with representations of the
     * resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for LoyaltyProgramAccountType
     * @uses LoyaltyProgramAccountType::setLoyaltyProgram()
     * @uses LoyaltyProgramAccountType::setAccountNumber()
     * @uses LoyaltyProgramAccountType::setSignInID()
     * @uses LoyaltyProgramAccountType::setTierCode()
     * @uses LoyaltyProgramAccountType::setTierName()
     * @uses LoyaltyProgramAccountType::setTierPriorityText()
     * @uses LoyaltyProgramAccountType::setURL()
     * @param \StructType\LoyaltyProgramType $loyaltyProgram
     * @param string $accountNumber
     * @param string $signInID
     * @param string $tierCode
     * @param string $tierName
     * @param string $tierPriorityText
     * @param string $uRL
     */
    public function __construct(\StructType\LoyaltyProgramType $loyaltyProgram = null, $accountNumber = null, $signInID = null, $tierCode = null, $tierName = null, $tierPriorityText = null, $uRL = null)
    {
        $this
            ->setLoyaltyProgram($loyaltyProgram)
            ->setAccountNumber($accountNumber)
            ->setSignInID($signInID)
            ->setTierCode($tierCode)
            ->setTierName($tierName)
            ->setTierPriorityText($tierPriorityText)
            ->setURL($uRL);
    }
    /**
     * Get LoyaltyProgram value
     * @return \StructType\LoyaltyProgramType
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * Set LoyaltyProgram value
     * @param \StructType\LoyaltyProgramType $loyaltyProgram
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setLoyaltyProgram(\StructType\LoyaltyProgramType $loyaltyProgram = null)
    {
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get SignInID value
     * @return string|null
     */
    public function getSignInID()
    {
        return $this->SignInID;
    }
    /**
     * Set SignInID value
     * @param string $signInID
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setSignInID($signInID = null)
    {
        // validation for constraint: string
        if (!is_null($signInID) && !is_string($signInID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signInID, true), gettype($signInID)), __LINE__);
        }
        $this->SignInID = $signInID;
        return $this;
    }
    /**
     * Get TierCode value
     * @return string|null
     */
    public function getTierCode()
    {
        return $this->TierCode;
    }
    /**
     * Set TierCode value
     * @param string $tierCode
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setTierCode($tierCode = null)
    {
        // validation for constraint: string
        if (!is_null($tierCode) && !is_string($tierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tierCode, true), gettype($tierCode)), __LINE__);
        }
        $this->TierCode = $tierCode;
        return $this;
    }
    /**
     * Get TierName value
     * @return string|null
     */
    public function getTierName()
    {
        return $this->TierName;
    }
    /**
     * Set TierName value
     * @param string $tierName
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setTierName($tierName = null)
    {
        // validation for constraint: string
        if (!is_null($tierName) && !is_string($tierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tierName, true), gettype($tierName)), __LINE__);
        }
        $this->TierName = $tierName;
        return $this;
    }
    /**
     * Get TierPriorityText value
     * @return string|null
     */
    public function getTierPriorityText()
    {
        return $this->TierPriorityText;
    }
    /**
     * Set TierPriorityText value
     * @param string $tierPriorityText
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setTierPriorityText($tierPriorityText = null)
    {
        // validation for constraint: string
        if (!is_null($tierPriorityText) && !is_string($tierPriorityText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tierPriorityText, true), gettype($tierPriorityText)), __LINE__);
        }
        $this->TierPriorityText = $tierPriorityText;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\LoyaltyProgramAccountType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
