<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyAmountType StructType
 * Meta information extracted from the WSDL
 * - documentation: An virtual currency amount of a Loyalty Program Account (is a number of monetary units).
 * @subpackage Structs
 */
class LoyaltyAmountType extends AbstractStructBase
{
    /**
     * The _
     * @var float
     */
    public $_;
    /**
     * The CurCode
     * Meta information extracted from the WSDL
     * - documentation: Currency Code as per ISO 4217 alphabetic code e.g. EUR, USD, AUD
     * - use: optional
     * @var string
     */
    public $CurCode;
    /**
     * Constructor method for LoyaltyAmountType
     * @uses LoyaltyAmountType::set_()
     * @uses LoyaltyAmountType::setCurCode()
     * @param float $_
     * @param string $curCode
     */
    public function __construct($_ = null, $curCode = null)
    {
        $this
            ->set_($_)
            ->setCurCode($curCode);
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\LoyaltyAmountType
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CurCode value
     * @return string|null
     */
    public function getCurCode()
    {
        return $this->CurCode;
    }
    /**
     * Set CurCode value
     * @param string $curCode
     * @return \StructType\LoyaltyAmountType
     */
    public function setCurCode($curCode = null)
    {
        // validation for constraint: string
        if (!is_null($curCode) && !is_string($curCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curCode, true), gettype($curCode)), __LINE__);
        }
        $this->CurCode = $curCode;
        return $this;
    }
}
