<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyAccrual StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the Loyalty credits that would be accrued with the specified offer
 * @subpackage Structs
 */
class LoyaltyAccrual extends AbstractStructBase
{
    /**
     * The StatusTier
     * Meta information extracted from the WSDL
     * - documentation: The current Status Tier for the traveler Example: Bronze
     * - minOccurs: 0
     * @var string
     */
    public $StatusTier;
    /**
     * The StatusTierCode
     * Meta information extracted from the WSDL
     * - documentation: The current Status Tier Code for the traveler Example "FFBR"
     * - minOccurs: 0
     * @var string
     */
    public $StatusTierCode;
    /**
     * The StatusCredits
     * Meta information extracted from the WSDL
     * - documentation: Frequent flyer credits counted toward program tier status advancement awarded if selecting this offer
     * - minOccurs: 0
     * @var int
     */
    public $StatusCredits;
    /**
     * The EarnedCredit
     * Meta information extracted from the WSDL
     * - documentation: Frequent flyer miles, points or other credit awarded if selecting this offer
     * - minOccurs: 0
     * @var int
     */
    public $EarnedCredit;
    /**
     * The ClassOfService
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassOfService;
    /**
     * Constructor method for LoyaltyAccrual
     * @uses LoyaltyAccrual::setStatusTier()
     * @uses LoyaltyAccrual::setStatusTierCode()
     * @uses LoyaltyAccrual::setStatusCredits()
     * @uses LoyaltyAccrual::setEarnedCredit()
     * @uses LoyaltyAccrual::setClassOfService()
     * @param string $statusTier
     * @param string $statusTierCode
     * @param int $statusCredits
     * @param int $earnedCredit
     * @param string $classOfService
     */
    public function __construct($statusTier = null, $statusTierCode = null, $statusCredits = null, $earnedCredit = null, $classOfService = null)
    {
        $this
            ->setStatusTier($statusTier)
            ->setStatusTierCode($statusTierCode)
            ->setStatusCredits($statusCredits)
            ->setEarnedCredit($earnedCredit)
            ->setClassOfService($classOfService);
    }
    /**
     * Get StatusTier value
     * @return string|null
     */
    public function getStatusTier()
    {
        return $this->StatusTier;
    }
    /**
     * Set StatusTier value
     * @param string $statusTier
     * @return \StructType\LoyaltyAccrual
     */
    public function setStatusTier($statusTier = null)
    {
        // validation for constraint: string
        if (!is_null($statusTier) && !is_string($statusTier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusTier, true), gettype($statusTier)), __LINE__);
        }
        $this->StatusTier = $statusTier;
        return $this;
    }
    /**
     * Get StatusTierCode value
     * @return string|null
     */
    public function getStatusTierCode()
    {
        return $this->StatusTierCode;
    }
    /**
     * Set StatusTierCode value
     * @param string $statusTierCode
     * @return \StructType\LoyaltyAccrual
     */
    public function setStatusTierCode($statusTierCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusTierCode) && !is_string($statusTierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusTierCode, true), gettype($statusTierCode)), __LINE__);
        }
        $this->StatusTierCode = $statusTierCode;
        return $this;
    }
    /**
     * Get StatusCredits value
     * @return int|null
     */
    public function getStatusCredits()
    {
        return $this->StatusCredits;
    }
    /**
     * Set StatusCredits value
     * @param int $statusCredits
     * @return \StructType\LoyaltyAccrual
     */
    public function setStatusCredits($statusCredits = null)
    {
        // validation for constraint: int
        if (!is_null($statusCredits) && !(is_int($statusCredits) || ctype_digit($statusCredits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCredits, true), gettype($statusCredits)), __LINE__);
        }
        $this->StatusCredits = $statusCredits;
        return $this;
    }
    /**
     * Get EarnedCredit value
     * @return int|null
     */
    public function getEarnedCredit()
    {
        return $this->EarnedCredit;
    }
    /**
     * Set EarnedCredit value
     * @param int $earnedCredit
     * @return \StructType\LoyaltyAccrual
     */
    public function setEarnedCredit($earnedCredit = null)
    {
        // validation for constraint: int
        if (!is_null($earnedCredit) && !(is_int($earnedCredit) || ctype_digit($earnedCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($earnedCredit, true), gettype($earnedCredit)), __LINE__);
        }
        $this->EarnedCredit = $earnedCredit;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \StructType\LoyaltyAccrual
     */
    public function setClassOfService($classOfService = null)
    {
        // validation for constraint: string
        if (!is_null($classOfService) && !is_string($classOfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classOfService, true), gettype($classOfService)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($classOfService) && mb_strlen($classOfService) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($classOfService)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($classOfService) && mb_strlen($classOfService) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($classOfService)), __LINE__);
        }
        $this->ClassOfService = $classOfService;
        return $this;
    }
}
