<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegCabinAssociationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container to enable cabins to be associated with legs.
 * @subpackage Structs
 */
class LegCabinAssociationsType extends AbstractStructBase
{
    /**
     * The LegsAssociatedCabin
     * Meta information extracted from the WSDL
     * - documentation: An association of cabin types to 1 or more legs.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\LegsAssociatedCabinType[]
     */
    public $LegsAssociatedCabin;
    /**
     * Constructor method for LegCabinAssociationsType
     * @uses LegCabinAssociationsType::setLegsAssociatedCabin()
     * @param \StructType\LegsAssociatedCabinType[] $legsAssociatedCabin
     */
    public function __construct(array $legsAssociatedCabin = array())
    {
        $this
            ->setLegsAssociatedCabin($legsAssociatedCabin);
    }
    /**
     * Get LegsAssociatedCabin value
     * @return \StructType\LegsAssociatedCabinType[]
     */
    public function getLegsAssociatedCabin()
    {
        return $this->LegsAssociatedCabin;
    }
    /**
     * This method is responsible for validating the values passed to the setLegsAssociatedCabin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLegsAssociatedCabin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLegsAssociatedCabinForArrayConstraintsFromSetLegsAssociatedCabin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $legCabinAssociationsTypeLegsAssociatedCabinItem) {
            // validation for constraint: itemType
            if (!$legCabinAssociationsTypeLegsAssociatedCabinItem instanceof \StructType\LegsAssociatedCabinType) {
                $invalidValues[] = is_object($legCabinAssociationsTypeLegsAssociatedCabinItem) ? get_class($legCabinAssociationsTypeLegsAssociatedCabinItem) : sprintf('%s(%s)', gettype($legCabinAssociationsTypeLegsAssociatedCabinItem), var_export($legCabinAssociationsTypeLegsAssociatedCabinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LegsAssociatedCabin property can only contain items of type \StructType\LegsAssociatedCabinType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LegsAssociatedCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\LegsAssociatedCabinType[] $legsAssociatedCabin
     * @return \StructType\LegCabinAssociationsType
     */
    public function setLegsAssociatedCabin(array $legsAssociatedCabin = array())
    {
        // validation for constraint: array
        if ('' !== ($legsAssociatedCabinArrayErrorMessage = self::validateLegsAssociatedCabinForArrayConstraintsFromSetLegsAssociatedCabin($legsAssociatedCabin))) {
            throw new \InvalidArgumentException($legsAssociatedCabinArrayErrorMessage, __LINE__);
        }
        $this->LegsAssociatedCabin = $legsAssociatedCabin;
        return $this;
    }
    /**
     * Add item to LegsAssociatedCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\LegsAssociatedCabinType $item
     * @return \StructType\LegCabinAssociationsType
     */
    public function addToLegsAssociatedCabin(\StructType\LegsAssociatedCabinType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LegsAssociatedCabinType) {
            throw new \InvalidArgumentException(sprintf('The LegsAssociatedCabin property can only contain items of type \StructType\LegsAssociatedCabinType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LegsAssociatedCabin[] = $item;
        return $this;
    }
}
