<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineSearchCriteriaRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: A search criteria type for interline requests.
 * @subpackage Structs
 */
class InterlineSearchCriteriaRequestType extends AbstractStructBase
{
    /**
     * The AirlineTaxonmy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonmy;
    /**
     * The AllianceCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filtering criteria based on Alliance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllianceCriteriaType[]
     */
    public $AllianceCriteria;
    /**
     * The CarrierCriteria
     * Meta information extracted from the WSDL
     * - documentation: Airline preferences for a shopping request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CarrierCriteriaType[]
     */
    public $CarrierCriteria;
    /**
     * The ConnectionCriteria
     * Meta information extracted from the WSDL
     * - documentation: Customer's requested connection information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConnectionCriteriaType[]
     */
    public $ConnectionCriteria;
    /**
     * The FareCriteria
     * Meta information extracted from the WSDL
     * - documentation: Fare criteria used to filter shopping results.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareCriteriaType[]
     */
    public $FareCriteria;
    /**
     * The FlightCriteria
     * Meta information extracted from the WSDL
     * - documentation: Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightCriteriaType[]
     */
    public $FlightCriteria;
    /**
     * The IATA_AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM. The same type may include aircrafts with different technical specifications such
     * as engines, range, cockpit configuration. Business Identifier Fields: - IATA Aircraft Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IATA_AircraftTypeType[]
     */
    public $IATA_AircraftType;
    /**
     * The OfferItemTypeCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filters results based on offer Item Type code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferItemTypeCriteriaType[]
     */
    public $OfferItemTypeCriteria;
    /**
     * The PricingMethodCriteria
     * Meta information extracted from the WSDL
     * - documentation: Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PricingMethodCriteriaType[]
     */
    public $PricingMethodCriteria;
    /**
     * The ProgramCriteria
     * Meta information extracted from the WSDL
     * - documentation: A negotiated program identifier ( e.g. CLID, Corporate codes ) to be passed between seller and retailer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProgramCriteriaType[]
     */
    public $ProgramCriteria;
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionType[]
     */
    public $Promotion;
    /**
     * The SeatCriteria
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatCriteriaType[]
     */
    public $SeatCriteria;
    /**
     * The SeatProfileCriteria
     * Meta information extracted from the WSDL
     * - documentation: Airline defined group of seats sharing common characteristics.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatProfileCriteriaType[]
     */
    public $SeatProfileCriteria;
    /**
     * The ServiceCriteria
     * Meta information extracted from the WSDL
     * - documentation: Reason for Issuance Group and Subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceCriteriaType[]
     */
    public $ServiceCriteria;
    /**
     * The SpecialService
     * Meta information extracted from the WSDL
     * - documentation: Special service information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialServiceType[]
     */
    public $SpecialService;
    /**
     * The TripPurposeCode
     * Meta information extracted from the WSDL
     * - documentation: Trip purpose information (e.g. Business, Leisure, etc.). | Trip purpose code Type BDT.
     * - base: TripPurposeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripPurposeCode;
    /**
     * Constructor method for InterlineSearchCriteriaRequestType
     * @uses InterlineSearchCriteriaRequestType::setAirlineTaxonmy()
     * @uses InterlineSearchCriteriaRequestType::setAllianceCriteria()
     * @uses InterlineSearchCriteriaRequestType::setCarrierCriteria()
     * @uses InterlineSearchCriteriaRequestType::setConnectionCriteria()
     * @uses InterlineSearchCriteriaRequestType::setFareCriteria()
     * @uses InterlineSearchCriteriaRequestType::setFlightCriteria()
     * @uses InterlineSearchCriteriaRequestType::setIATA_AircraftType()
     * @uses InterlineSearchCriteriaRequestType::setOfferItemTypeCriteria()
     * @uses InterlineSearchCriteriaRequestType::setPricingMethodCriteria()
     * @uses InterlineSearchCriteriaRequestType::setProgramCriteria()
     * @uses InterlineSearchCriteriaRequestType::setPromotion()
     * @uses InterlineSearchCriteriaRequestType::setSeatCriteria()
     * @uses InterlineSearchCriteriaRequestType::setSeatProfileCriteria()
     * @uses InterlineSearchCriteriaRequestType::setServiceCriteria()
     * @uses InterlineSearchCriteriaRequestType::setSpecialService()
     * @uses InterlineSearchCriteriaRequestType::setTripPurposeCode()
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonmy
     * @param \StructType\AllianceCriteriaType[] $allianceCriteria
     * @param \StructType\CarrierCriteriaType[] $carrierCriteria
     * @param \StructType\ConnectionCriteriaType[] $connectionCriteria
     * @param \StructType\FareCriteriaType[] $fareCriteria
     * @param \StructType\FlightCriteriaType[] $flightCriteria
     * @param \StructType\IATA_AircraftTypeType[] $iATA_AircraftType
     * @param \StructType\OfferItemTypeCriteriaType[] $offerItemTypeCriteria
     * @param \StructType\PricingMethodCriteriaType[] $pricingMethodCriteria
     * @param \StructType\ProgramCriteriaType[] $programCriteria
     * @param \StructType\PromotionType[] $promotion
     * @param \StructType\SeatCriteriaType[] $seatCriteria
     * @param \StructType\SeatProfileCriteriaType[] $seatProfileCriteria
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     * @param \StructType\SpecialServiceType[] $specialService
     * @param string $tripPurposeCode
     */
    public function __construct(array $airlineTaxonmy = array(), array $allianceCriteria = array(), array $carrierCriteria = array(), array $connectionCriteria = array(), array $fareCriteria = array(), array $flightCriteria = array(), array $iATA_AircraftType = array(), array $offerItemTypeCriteria = array(), array $pricingMethodCriteria = array(), array $programCriteria = array(), array $promotion = array(), array $seatCriteria = array(), array $seatProfileCriteria = array(), array $serviceCriteria = array(), array $specialService = array(), $tripPurposeCode = null)
    {
        $this
            ->setAirlineTaxonmy($airlineTaxonmy)
            ->setAllianceCriteria($allianceCriteria)
            ->setCarrierCriteria($carrierCriteria)
            ->setConnectionCriteria($connectionCriteria)
            ->setFareCriteria($fareCriteria)
            ->setFlightCriteria($flightCriteria)
            ->setIATA_AircraftType($iATA_AircraftType)
            ->setOfferItemTypeCriteria($offerItemTypeCriteria)
            ->setPricingMethodCriteria($pricingMethodCriteria)
            ->setProgramCriteria($programCriteria)
            ->setPromotion($promotion)
            ->setSeatCriteria($seatCriteria)
            ->setSeatProfileCriteria($seatProfileCriteria)
            ->setServiceCriteria($serviceCriteria)
            ->setSpecialService($specialService)
            ->setTripPurposeCode($tripPurposeCode);
    }
    /**
     * Get AirlineTaxonmy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonmy()
    {
        return $this->AirlineTaxonmy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonmy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonmy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonmyForArrayConstraintsFromSetAirlineTaxonmy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeAirlineTaxonmyItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeAirlineTaxonmyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeAirlineTaxonmyItem) ? get_class($interlineSearchCriteriaRequestTypeAirlineTaxonmyItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeAirlineTaxonmyItem), var_export($interlineSearchCriteriaRequestTypeAirlineTaxonmyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonmy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonmy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonmy
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setAirlineTaxonmy(array $airlineTaxonmy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonmyArrayErrorMessage = self::validateAirlineTaxonmyForArrayConstraintsFromSetAirlineTaxonmy($airlineTaxonmy))) {
            throw new \InvalidArgumentException($airlineTaxonmyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonmy = $airlineTaxonmy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonmy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToAirlineTaxonmy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonmy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonmy[] = $item;
        return $this;
    }
    /**
     * Get AllianceCriteria value
     * @return \StructType\AllianceCriteriaType[]|null
     */
    public function getAllianceCriteria()
    {
        return $this->AllianceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceCriteriaForArrayConstraintsFromSetAllianceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeAllianceCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeAllianceCriteriaItem instanceof \StructType\AllianceCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeAllianceCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeAllianceCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeAllianceCriteriaItem), var_export($interlineSearchCriteriaRequestTypeAllianceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceCriteria property can only contain items of type \StructType\AllianceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceCriteriaType[] $allianceCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setAllianceCriteria(array $allianceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceCriteriaArrayErrorMessage = self::validateAllianceCriteriaForArrayConstraintsFromSetAllianceCriteria($allianceCriteria))) {
            throw new \InvalidArgumentException($allianceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->AllianceCriteria = $allianceCriteria;
        return $this;
    }
    /**
     * Add item to AllianceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToAllianceCriteria(\StructType\AllianceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllianceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The AllianceCriteria property can only contain items of type \StructType\AllianceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceCriteria[] = $item;
        return $this;
    }
    /**
     * Get CarrierCriteria value
     * @return \StructType\CarrierCriteriaType[]|null
     */
    public function getCarrierCriteria()
    {
        return $this->CarrierCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierCriteriaForArrayConstraintsFromSetCarrierCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeCarrierCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeCarrierCriteriaItem instanceof \StructType\CarrierCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeCarrierCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeCarrierCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeCarrierCriteriaItem), var_export($interlineSearchCriteriaRequestTypeCarrierCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierCriteria property can only contain items of type \StructType\CarrierCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierCriteriaType[] $carrierCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setCarrierCriteria(array $carrierCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierCriteriaArrayErrorMessage = self::validateCarrierCriteriaForArrayConstraintsFromSetCarrierCriteria($carrierCriteria))) {
            throw new \InvalidArgumentException($carrierCriteriaArrayErrorMessage, __LINE__);
        }
        $this->CarrierCriteria = $carrierCriteria;
        return $this;
    }
    /**
     * Add item to CarrierCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToCarrierCriteria(\StructType\CarrierCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The CarrierCriteria property can only contain items of type \StructType\CarrierCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierCriteria[] = $item;
        return $this;
    }
    /**
     * Get ConnectionCriteria value
     * @return \StructType\ConnectionCriteriaType[]|null
     */
    public function getConnectionCriteria()
    {
        return $this->ConnectionCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectionCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectionCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectionCriteriaForArrayConstraintsFromSetConnectionCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeConnectionCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeConnectionCriteriaItem instanceof \StructType\ConnectionCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeConnectionCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeConnectionCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeConnectionCriteriaItem), var_export($interlineSearchCriteriaRequestTypeConnectionCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectionCriteria property can only contain items of type \StructType\ConnectionCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionCriteriaType[] $connectionCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setConnectionCriteria(array $connectionCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($connectionCriteriaArrayErrorMessage = self::validateConnectionCriteriaForArrayConstraintsFromSetConnectionCriteria($connectionCriteria))) {
            throw new \InvalidArgumentException($connectionCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ConnectionCriteria = $connectionCriteria;
        return $this;
    }
    /**
     * Add item to ConnectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToConnectionCriteria(\StructType\ConnectionCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ConnectionCriteria property can only contain items of type \StructType\ConnectionCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConnectionCriteria[] = $item;
        return $this;
    }
    /**
     * Get FareCriteria value
     * @return \StructType\FareCriteriaType[]|null
     */
    public function getFareCriteria()
    {
        return $this->FareCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFareCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareCriteriaForArrayConstraintsFromSetFareCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeFareCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeFareCriteriaItem instanceof \StructType\FareCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeFareCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeFareCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeFareCriteriaItem), var_export($interlineSearchCriteriaRequestTypeFareCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareCriteria property can only contain items of type \StructType\FareCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareCriteriaType[] $fareCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setFareCriteria(array $fareCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($fareCriteriaArrayErrorMessage = self::validateFareCriteriaForArrayConstraintsFromSetFareCriteria($fareCriteria))) {
            throw new \InvalidArgumentException($fareCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FareCriteria = $fareCriteria;
        return $this;
    }
    /**
     * Add item to FareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToFareCriteria(\StructType\FareCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FareCriteria property can only contain items of type \StructType\FareCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareCriteria[] = $item;
        return $this;
    }
    /**
     * Get FlightCriteria value
     * @return \StructType\FlightCriteriaType[]|null
     */
    public function getFlightCriteria()
    {
        return $this->FlightCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightCriteriaForArrayConstraintsFromSetFlightCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeFlightCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeFlightCriteriaItem instanceof \StructType\FlightCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeFlightCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeFlightCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeFlightCriteriaItem), var_export($interlineSearchCriteriaRequestTypeFlightCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightCriteria property can only contain items of type \StructType\FlightCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCriteriaType[] $flightCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setFlightCriteria(array $flightCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($flightCriteriaArrayErrorMessage = self::validateFlightCriteriaForArrayConstraintsFromSetFlightCriteria($flightCriteria))) {
            throw new \InvalidArgumentException($flightCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FlightCriteria = $flightCriteria;
        return $this;
    }
    /**
     * Add item to FlightCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToFlightCriteria(\StructType\FlightCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FlightCriteria property can only contain items of type \StructType\FlightCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightCriteria[] = $item;
        return $this;
    }
    /**
     * Get IATA_AircraftType value
     * @return \StructType\IATA_AircraftTypeType[]|null
     */
    public function getIATA_AircraftType()
    {
        return $this->IATA_AircraftType;
    }
    /**
     * This method is responsible for validating the values passed to the setIATA_AircraftType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIATA_AircraftType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIATA_AircraftTypeForArrayConstraintsFromSetIATA_AircraftType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem instanceof \StructType\IATA_AircraftTypeType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem) ? get_class($interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem), var_export($interlineSearchCriteriaRequestTypeIATA_AircraftTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IATA_AircraftType property can only contain items of type \StructType\IATA_AircraftTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IATA_AircraftType value
     * @throws \InvalidArgumentException
     * @param \StructType\IATA_AircraftTypeType[] $iATA_AircraftType
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setIATA_AircraftType(array $iATA_AircraftType = array())
    {
        // validation for constraint: array
        if ('' !== ($iATA_AircraftTypeArrayErrorMessage = self::validateIATA_AircraftTypeForArrayConstraintsFromSetIATA_AircraftType($iATA_AircraftType))) {
            throw new \InvalidArgumentException($iATA_AircraftTypeArrayErrorMessage, __LINE__);
        }
        $this->IATA_AircraftType = $iATA_AircraftType;
        return $this;
    }
    /**
     * Add item to IATA_AircraftType value
     * @throws \InvalidArgumentException
     * @param \StructType\IATA_AircraftTypeType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToIATA_AircraftType(\StructType\IATA_AircraftTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IATA_AircraftTypeType) {
            throw new \InvalidArgumentException(sprintf('The IATA_AircraftType property can only contain items of type \StructType\IATA_AircraftTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IATA_AircraftType[] = $item;
        return $this;
    }
    /**
     * Get OfferItemTypeCriteria value
     * @return \StructType\OfferItemTypeCriteriaType[]|null
     */
    public function getOfferItemTypeCriteria()
    {
        return $this->OfferItemTypeCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemTypeCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemTypeCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemTypeCriteriaForArrayConstraintsFromSetOfferItemTypeCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem instanceof \StructType\OfferItemTypeCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem), var_export($interlineSearchCriteriaRequestTypeOfferItemTypeCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemTypeCriteria property can only contain items of type \StructType\OfferItemTypeCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItemTypeCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTypeCriteriaType[] $offerItemTypeCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setOfferItemTypeCriteria(array $offerItemTypeCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemTypeCriteriaArrayErrorMessage = self::validateOfferItemTypeCriteriaForArrayConstraintsFromSetOfferItemTypeCriteria($offerItemTypeCriteria))) {
            throw new \InvalidArgumentException($offerItemTypeCriteriaArrayErrorMessage, __LINE__);
        }
        $this->OfferItemTypeCriteria = $offerItemTypeCriteria;
        return $this;
    }
    /**
     * Add item to OfferItemTypeCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTypeCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToOfferItemTypeCriteria(\StructType\OfferItemTypeCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferItemTypeCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The OfferItemTypeCriteria property can only contain items of type \StructType\OfferItemTypeCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItemTypeCriteria[] = $item;
        return $this;
    }
    /**
     * Get PricingMethodCriteria value
     * @return \StructType\PricingMethodCriteriaType[]|null
     */
    public function getPricingMethodCriteria()
    {
        return $this->PricingMethodCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingMethodCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingMethodCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingMethodCriteriaForArrayConstraintsFromSetPricingMethodCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypePricingMethodCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypePricingMethodCriteriaItem instanceof \StructType\PricingMethodCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypePricingMethodCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypePricingMethodCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypePricingMethodCriteriaItem), var_export($interlineSearchCriteriaRequestTypePricingMethodCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingMethodCriteria property can only contain items of type \StructType\PricingMethodCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingMethodCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingMethodCriteriaType[] $pricingMethodCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setPricingMethodCriteria(array $pricingMethodCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingMethodCriteriaArrayErrorMessage = self::validatePricingMethodCriteriaForArrayConstraintsFromSetPricingMethodCriteria($pricingMethodCriteria))) {
            throw new \InvalidArgumentException($pricingMethodCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PricingMethodCriteria = $pricingMethodCriteria;
        return $this;
    }
    /**
     * Add item to PricingMethodCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingMethodCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToPricingMethodCriteria(\StructType\PricingMethodCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingMethodCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PricingMethodCriteria property can only contain items of type \StructType\PricingMethodCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PricingMethodCriteria[] = $item;
        return $this;
    }
    /**
     * Get ProgramCriteria value
     * @return \StructType\ProgramCriteriaType[]|null
     */
    public function getProgramCriteria()
    {
        return $this->ProgramCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramCriteriaForArrayConstraintsFromSetProgramCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeProgramCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeProgramCriteriaItem instanceof \StructType\ProgramCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeProgramCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeProgramCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeProgramCriteriaItem), var_export($interlineSearchCriteriaRequestTypeProgramCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramCriteria property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType[] $programCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setProgramCriteria(array $programCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($programCriteriaArrayErrorMessage = self::validateProgramCriteriaForArrayConstraintsFromSetProgramCriteria($programCriteria))) {
            throw new \InvalidArgumentException($programCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ProgramCriteria = $programCriteria;
        return $this;
    }
    /**
     * Add item to ProgramCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToProgramCriteria(\StructType\ProgramCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ProgramCriteria property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramCriteria[] = $item;
        return $this;
    }
    /**
     * Get Promotion value
     * @return \StructType\PromotionType[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypePromotionItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypePromotionItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypePromotionItem) ? get_class($interlineSearchCriteriaRequestTypePromotionItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypePromotionItem), var_export($interlineSearchCriteriaRequestTypePromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotion
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToPromotion(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Get SeatCriteria value
     * @return \StructType\SeatCriteriaType[]|null
     */
    public function getSeatCriteria()
    {
        return $this->SeatCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCriteriaForArrayConstraintsFromSetSeatCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeSeatCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeSeatCriteriaItem instanceof \StructType\SeatCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeSeatCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeSeatCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeSeatCriteriaItem), var_export($interlineSearchCriteriaRequestTypeSeatCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCriteria property can only contain items of type \StructType\SeatCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatCriteriaType[] $seatCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setSeatCriteria(array $seatCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCriteriaArrayErrorMessage = self::validateSeatCriteriaForArrayConstraintsFromSetSeatCriteria($seatCriteria))) {
            throw new \InvalidArgumentException($seatCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SeatCriteria = $seatCriteria;
        return $this;
    }
    /**
     * Add item to SeatCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToSeatCriteria(\StructType\SeatCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The SeatCriteria property can only contain items of type \StructType\SeatCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCriteria[] = $item;
        return $this;
    }
    /**
     * Get SeatProfileCriteria value
     * @return \StructType\SeatProfileCriteriaType[]|null
     */
    public function getSeatProfileCriteria()
    {
        return $this->SeatProfileCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatProfileCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatProfileCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatProfileCriteriaForArrayConstraintsFromSetSeatProfileCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem instanceof \StructType\SeatProfileCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem), var_export($interlineSearchCriteriaRequestTypeSeatProfileCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatProfileCriteria property can only contain items of type \StructType\SeatProfileCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatProfileCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatProfileCriteriaType[] $seatProfileCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setSeatProfileCriteria(array $seatProfileCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($seatProfileCriteriaArrayErrorMessage = self::validateSeatProfileCriteriaForArrayConstraintsFromSetSeatProfileCriteria($seatProfileCriteria))) {
            throw new \InvalidArgumentException($seatProfileCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SeatProfileCriteria = $seatProfileCriteria;
        return $this;
    }
    /**
     * Add item to SeatProfileCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatProfileCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToSeatProfileCriteria(\StructType\SeatProfileCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatProfileCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The SeatProfileCriteria property can only contain items of type \StructType\SeatProfileCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatProfileCriteria[] = $item;
        return $this;
    }
    /**
     * Get ServiceCriteria value
     * @return \StructType\ServiceCriteriaType[]|null
     */
    public function getServiceCriteria()
    {
        return $this->ServiceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeServiceCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeServiceCriteriaItem instanceof \StructType\ServiceCriteriaType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeServiceCriteriaItem) ? get_class($interlineSearchCriteriaRequestTypeServiceCriteriaItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeServiceCriteriaItem), var_export($interlineSearchCriteriaRequestTypeServiceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setServiceCriteria(array $serviceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCriteriaArrayErrorMessage = self::validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria($serviceCriteria))) {
            throw new \InvalidArgumentException($serviceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ServiceCriteria = $serviceCriteria;
        return $this;
    }
    /**
     * Add item to ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToServiceCriteria(\StructType\ServiceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCriteria[] = $item;
        return $this;
    }
    /**
     * Get SpecialService value
     * @return \StructType\SpecialServiceType[]|null
     */
    public function getSpecialService()
    {
        return $this->SpecialService;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialServiceForArrayConstraintsFromSetSpecialService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineSearchCriteriaRequestTypeSpecialServiceItem) {
            // validation for constraint: itemType
            if (!$interlineSearchCriteriaRequestTypeSpecialServiceItem instanceof \StructType\SpecialServiceType) {
                $invalidValues[] = is_object($interlineSearchCriteriaRequestTypeSpecialServiceItem) ? get_class($interlineSearchCriteriaRequestTypeSpecialServiceItem) : sprintf('%s(%s)', gettype($interlineSearchCriteriaRequestTypeSpecialServiceItem), var_export($interlineSearchCriteriaRequestTypeSpecialServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType[] $specialService
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setSpecialService(array $specialService = array())
    {
        // validation for constraint: array
        if ('' !== ($specialServiceArrayErrorMessage = self::validateSpecialServiceForArrayConstraintsFromSetSpecialService($specialService))) {
            throw new \InvalidArgumentException($specialServiceArrayErrorMessage, __LINE__);
        }
        $this->SpecialService = $specialService;
        return $this;
    }
    /**
     * Add item to SpecialService value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType $item
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function addToSpecialService(\StructType\SpecialServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialServiceType) {
            throw new \InvalidArgumentException(sprintf('The SpecialService property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialService[] = $item;
        return $this;
    }
    /**
     * Get TripPurposeCode value
     * @return string|null
     */
    public function getTripPurposeCode()
    {
        return $this->TripPurposeCode;
    }
    /**
     * Set TripPurposeCode value
     * @param string $tripPurposeCode
     * @return \StructType\InterlineSearchCriteriaRequestType
     */
    public function setTripPurposeCode($tripPurposeCode = null)
    {
        // validation for constraint: string
        if (!is_null($tripPurposeCode) && !is_string($tripPurposeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripPurposeCode, true), gettype($tripPurposeCode)), __LINE__);
        }
        $this->TripPurposeCode = $tripPurposeCode;
        return $this;
    }
}
