<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOriginDestCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
 * @subpackage Structs
 */
class InterlineOriginDestCriteriaType extends AbstractStructBase
{
    /**
     * The ArrivalCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Customer's requested Destination arrival time and location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DestArrivalCriteriaType
     */
    public $ArrivalCriteria;
    /**
     * The DepCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Customer's requested Origin departure time and location.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OriginDepCriteriaType
     */
    public $DepCriteria;
    /**
     * The CabinCriteria
     * Meta information extracted from the WSDL
     * - documentation: Shopping Request specialisation of Cabin Type base type definition: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestCabinTypeType[]
     */
    public $CabinCriteria;
    /**
     * The ConnectionCriteriaRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a unique identifier assigned to this transfer preference. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionCriteriaRefID;
    /**
     * The JourneyDurationCriteria
     * Meta information extracted from the WSDL
     * - documentation: Total journey travel time per bound preferences. This includes the sum of all flight durations as well as connection times.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JourneyDurationCriteriaType
     */
    public $JourneyDurationCriteria;
    /**
     * The OriginDestID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an Origin Destination within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginDestID;
    /**
     * The PaxSegmentCriteria
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlinePaxSegmentCriteriaType[]
     */
    public $PaxSegmentCriteria;
    /**
     * Constructor method for InterlineOriginDestCriteriaType
     * @uses InterlineOriginDestCriteriaType::setArrivalCriteria()
     * @uses InterlineOriginDestCriteriaType::setDepCriteria()
     * @uses InterlineOriginDestCriteriaType::setCabinCriteria()
     * @uses InterlineOriginDestCriteriaType::setConnectionCriteriaRefID()
     * @uses InterlineOriginDestCriteriaType::setJourneyDurationCriteria()
     * @uses InterlineOriginDestCriteriaType::setOriginDestID()
     * @uses InterlineOriginDestCriteriaType::setPaxSegmentCriteria()
     * @param \StructType\DestArrivalCriteriaType $arrivalCriteria
     * @param \StructType\OriginDepCriteriaType $depCriteria
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinCriteria
     * @param string $connectionCriteriaRefID
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     * @param string $originDestID
     * @param \StructType\InterlinePaxSegmentCriteriaType[] $paxSegmentCriteria
     */
    public function __construct(\StructType\DestArrivalCriteriaType $arrivalCriteria = null, \StructType\OriginDepCriteriaType $depCriteria = null, array $cabinCriteria = array(), $connectionCriteriaRefID = null, \StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null, $originDestID = null, array $paxSegmentCriteria = array())
    {
        $this
            ->setArrivalCriteria($arrivalCriteria)
            ->setDepCriteria($depCriteria)
            ->setCabinCriteria($cabinCriteria)
            ->setConnectionCriteriaRefID($connectionCriteriaRefID)
            ->setJourneyDurationCriteria($journeyDurationCriteria)
            ->setOriginDestID($originDestID)
            ->setPaxSegmentCriteria($paxSegmentCriteria);
    }
    /**
     * Get ArrivalCriteria value
     * @return \StructType\DestArrivalCriteriaType
     */
    public function getArrivalCriteria()
    {
        return $this->ArrivalCriteria;
    }
    /**
     * Set ArrivalCriteria value
     * @param \StructType\DestArrivalCriteriaType $arrivalCriteria
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setArrivalCriteria(\StructType\DestArrivalCriteriaType $arrivalCriteria = null)
    {
        $this->ArrivalCriteria = $arrivalCriteria;
        return $this;
    }
    /**
     * Get DepCriteria value
     * @return \StructType\OriginDepCriteriaType
     */
    public function getDepCriteria()
    {
        return $this->DepCriteria;
    }
    /**
     * Set DepCriteria value
     * @param \StructType\OriginDepCriteriaType $depCriteria
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setDepCriteria(\StructType\OriginDepCriteriaType $depCriteria = null)
    {
        $this->DepCriteria = $depCriteria;
        return $this;
    }
    /**
     * Get CabinCriteria value
     * @return \StructType\ShoppingRequestCabinTypeType[]|null
     */
    public function getCabinCriteria()
    {
        return $this->CabinCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinCriteriaForArrayConstraintsFromSetCabinCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOriginDestCriteriaTypeCabinCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineOriginDestCriteriaTypeCabinCriteriaItem instanceof \StructType\ShoppingRequestCabinTypeType) {
                $invalidValues[] = is_object($interlineOriginDestCriteriaTypeCabinCriteriaItem) ? get_class($interlineOriginDestCriteriaTypeCabinCriteriaItem) : sprintf('%s(%s)', gettype($interlineOriginDestCriteriaTypeCabinCriteriaItem), var_export($interlineOriginDestCriteriaTypeCabinCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinCriteria property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinCriteria
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setCabinCriteria(array $cabinCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinCriteriaArrayErrorMessage = self::validateCabinCriteriaForArrayConstraintsFromSetCabinCriteria($cabinCriteria))) {
            throw new \InvalidArgumentException($cabinCriteriaArrayErrorMessage, __LINE__);
        }
        $this->CabinCriteria = $cabinCriteria;
        return $this;
    }
    /**
     * Add item to CabinCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType $item
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function addToCabinCriteria(\StructType\ShoppingRequestCabinTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingRequestCabinTypeType) {
            throw new \InvalidArgumentException(sprintf('The CabinCriteria property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinCriteria[] = $item;
        return $this;
    }
    /**
     * Get ConnectionCriteriaRefID value
     * @return string|null
     */
    public function getConnectionCriteriaRefID()
    {
        return $this->ConnectionCriteriaRefID;
    }
    /**
     * Set ConnectionCriteriaRefID value
     * @param string $connectionCriteriaRefID
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setConnectionCriteriaRefID($connectionCriteriaRefID = null)
    {
        // validation for constraint: string
        if (!is_null($connectionCriteriaRefID) && !is_string($connectionCriteriaRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionCriteriaRefID, true), gettype($connectionCriteriaRefID)), __LINE__);
        }
        $this->ConnectionCriteriaRefID = $connectionCriteriaRefID;
        return $this;
    }
    /**
     * Get JourneyDurationCriteria value
     * @return \StructType\JourneyDurationCriteriaType|null
     */
    public function getJourneyDurationCriteria()
    {
        return $this->JourneyDurationCriteria;
    }
    /**
     * Set JourneyDurationCriteria value
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setJourneyDurationCriteria(\StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null)
    {
        $this->JourneyDurationCriteria = $journeyDurationCriteria;
        return $this;
    }
    /**
     * Get OriginDestID value
     * @return string|null
     */
    public function getOriginDestID()
    {
        return $this->OriginDestID;
    }
    /**
     * Set OriginDestID value
     * @param string $originDestID
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setOriginDestID($originDestID = null)
    {
        // validation for constraint: string
        if (!is_null($originDestID) && !is_string($originDestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDestID, true), gettype($originDestID)), __LINE__);
        }
        $this->OriginDestID = $originDestID;
        return $this;
    }
    /**
     * Get PaxSegmentCriteria value
     * @return \StructType\InterlinePaxSegmentCriteriaType[]|null
     */
    public function getPaxSegmentCriteria()
    {
        return $this->PaxSegmentCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentCriteriaForArrayConstraintsFromSetPaxSegmentCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOriginDestCriteriaTypePaxSegmentCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineOriginDestCriteriaTypePaxSegmentCriteriaItem instanceof \StructType\InterlinePaxSegmentCriteriaType) {
                $invalidValues[] = is_object($interlineOriginDestCriteriaTypePaxSegmentCriteriaItem) ? get_class($interlineOriginDestCriteriaTypePaxSegmentCriteriaItem) : sprintf('%s(%s)', gettype($interlineOriginDestCriteriaTypePaxSegmentCriteriaItem), var_export($interlineOriginDestCriteriaTypePaxSegmentCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentCriteria property can only contain items of type \StructType\InterlinePaxSegmentCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlinePaxSegmentCriteriaType[] $paxSegmentCriteria
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function setPaxSegmentCriteria(array $paxSegmentCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentCriteriaArrayErrorMessage = self::validatePaxSegmentCriteriaForArrayConstraintsFromSetPaxSegmentCriteria($paxSegmentCriteria))) {
            throw new \InvalidArgumentException($paxSegmentCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentCriteria = $paxSegmentCriteria;
        return $this;
    }
    /**
     * Add item to PaxSegmentCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlinePaxSegmentCriteriaType $item
     * @return \StructType\InterlineOriginDestCriteriaType
     */
    public function addToPaxSegmentCriteria(\StructType\InterlinePaxSegmentCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlinePaxSegmentCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentCriteria property can only contain items of type \StructType\InterlinePaxSegmentCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentCriteria[] = $item;
        return $this;
    }
}
