<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: An Interline individually priced item within an Interline Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class InterlineOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The GrandTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Reflects the Differential Total Amount and the Penalty Total Amount, if netted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $GrandTotalAmount;
    /**
     * The OrderItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Order Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderItemTypeCode;
    /**
     * The OwnerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether or not the owner is the ORA or POA. | Specifies the type of Owner for a given Offer/Order/Order Item (E.g. ORA, POA).
     * - base: OwnerTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerTypeCode;
    /**
     * The ReusableInd
     * Meta information extracted from the WSDL
     * - documentation: If Reusable = true, indicates that part of the value of the OrderItem may be reused for reshopping or refund. Exact reusable amount is unknown until Seller requests to reshop or to process a refund for this OrderItem. | An indicator
     * is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReusableInd;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Interline Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a
     * service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineServiceType[]
     */
    public $Service;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Item Status instance. See ATSB Codeset OrderItem for possible values. | The possible statuses of an Order Item {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Item Status,
     * Coded.{/codeListName} {codeListIdentifier}ORDERITEM{/codeListIdentifier} | represents the status of an Order Item
     * - base: OrderItemStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for InterlineOrderItemType
     * @uses InterlineOrderItemType::setOrderItemID()
     * @uses InterlineOrderItemType::setOwnerCode()
     * @uses InterlineOrderItemType::setGrandTotalAmount()
     * @uses InterlineOrderItemType::setOrderItemTypeCode()
     * @uses InterlineOrderItemType::setOwnerTypeCode()
     * @uses InterlineOrderItemType::setReusableInd()
     * @uses InterlineOrderItemType::setService()
     * @uses InterlineOrderItemType::setStatusCode()
     * @uses InterlineOrderItemType::setWebAddressURI()
     * @param string $orderItemID
     * @param string $ownerCode
     * @param \StructType\AmountType $grandTotalAmount
     * @param string $orderItemTypeCode
     * @param string $ownerTypeCode
     * @param bool $reusableInd
     * @param \StructType\InterlineServiceType[] $service
     * @param string $statusCode
     * @param string $webAddressURI
     */
    public function __construct($orderItemID = null, $ownerCode = null, \StructType\AmountType $grandTotalAmount = null, $orderItemTypeCode = null, $ownerTypeCode = null, $reusableInd = null, array $service = array(), $statusCode = null, $webAddressURI = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setOwnerCode($ownerCode)
            ->setGrandTotalAmount($grandTotalAmount)
            ->setOrderItemTypeCode($orderItemTypeCode)
            ->setOwnerTypeCode($ownerTypeCode)
            ->setReusableInd($reusableInd)
            ->setService($service)
            ->setStatusCode($statusCode)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderItemID value
     * @return string
     */
    public function getOrderItemID()
    {
        return $this->OrderItemID;
    }
    /**
     * Set OrderItemID value
     * @param string $orderItemID
     * @return \StructType\InterlineOrderItemType
     */
    public function setOrderItemID($orderItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemID) && !is_string($orderItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemID, true), gettype($orderItemID)), __LINE__);
        }
        $this->OrderItemID = $orderItemID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\InterlineOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get GrandTotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getGrandTotalAmount()
    {
        return $this->GrandTotalAmount;
    }
    /**
     * Set GrandTotalAmount value
     * @param \StructType\AmountType $grandTotalAmount
     * @return \StructType\InterlineOrderItemType
     */
    public function setGrandTotalAmount(\StructType\AmountType $grandTotalAmount = null)
    {
        $this->GrandTotalAmount = $grandTotalAmount;
        return $this;
    }
    /**
     * Get OrderItemTypeCode value
     * @return string|null
     */
    public function getOrderItemTypeCode()
    {
        return $this->OrderItemTypeCode;
    }
    /**
     * Set OrderItemTypeCode value
     * @param string $orderItemTypeCode
     * @return \StructType\InterlineOrderItemType
     */
    public function setOrderItemTypeCode($orderItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemTypeCode) && !is_string($orderItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemTypeCode, true), gettype($orderItemTypeCode)), __LINE__);
        }
        $this->OrderItemTypeCode = $orderItemTypeCode;
        return $this;
    }
    /**
     * Get OwnerTypeCode value
     * @return string|null
     */
    public function getOwnerTypeCode()
    {
        return $this->OwnerTypeCode;
    }
    /**
     * Set OwnerTypeCode value
     * @param string $ownerTypeCode
     * @return \StructType\InterlineOrderItemType
     */
    public function setOwnerTypeCode($ownerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerTypeCode) && !is_string($ownerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerTypeCode, true), gettype($ownerTypeCode)), __LINE__);
        }
        $this->OwnerTypeCode = $ownerTypeCode;
        return $this;
    }
    /**
     * Get ReusableInd value
     * @return bool|null
     */
    public function getReusableInd()
    {
        return $this->ReusableInd;
    }
    /**
     * Set ReusableInd value
     * @param bool $reusableInd
     * @return \StructType\InterlineOrderItemType
     */
    public function setReusableInd($reusableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reusableInd) && !is_bool($reusableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reusableInd, true), gettype($reusableInd)), __LINE__);
        }
        $this->ReusableInd = $reusableInd;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\InterlineServiceType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$interlineOrderItemTypeServiceItem instanceof \StructType\InterlineServiceType) {
                $invalidValues[] = is_object($interlineOrderItemTypeServiceItem) ? get_class($interlineOrderItemTypeServiceItem) : sprintf('%s(%s)', gettype($interlineOrderItemTypeServiceItem), var_export($interlineOrderItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\InterlineServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineServiceType[] $service
     * @return \StructType\InterlineOrderItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineServiceType $item
     * @return \StructType\InterlineOrderItemType
     */
    public function addToService(\StructType\InterlineServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\InterlineServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\InterlineOrderItemType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\InterlineOrderItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
