<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOfferResponsePayloadType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payload for Interline Offer response message
 * @subpackage Structs
 */
class InterlineOfferResponsePayloadType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceList
     * Meta information extracted from the WSDL
     * - documentation: Baggage allowance data list definition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageAllowanceListType
     */
    public $BaggageAllowanceList;
    /**
     * The BaggageDisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Baggage disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageDisclosureListType
     */
    public $BaggageDisclosureList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType[]
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType[]
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType[]
     */
    public $DatedOperatingSegmentList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DisclosureListType
     */
    public $DisclosureList;
    /**
     * The InterlineOffers
     * Meta information extracted from the WSDL
     * - documentation: New Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
     * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
     * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
     * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierOfferType[]
     */
    public $InterlineOffers;
    /**
     * The MarketingMessage
     * Meta information extracted from the WSDL
     * - documentation: Marketing message: Additional, supplementary information about the document or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketingMessageType[]
     */
    public $MarketingMessage;
    /**
     * The OptionalOffers
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineALaCarteOfferType[]
     */
    public $OptionalOffers;
    /**
     * The PaxJourneyList
     * Meta information extracted from the WSDL
     * - documentation: Journey data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxJourneyListType
     */
    public $PaxJourneyList;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The PaxSegmentList
     * Meta information extracted from the WSDL
     * - documentation: Segment data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentListType
     */
    public $PaxSegmentList;
    /**
     * The ServiceDefinitionList
     * Meta information extracted from the WSDL
     * - documentation: Service Definition data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDefinitionListType
     */
    public $ServiceDefinitionList;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for InterlineOfferResponsePayloadType
     * @uses InterlineOfferResponsePayloadType::setBaggageAllowanceList()
     * @uses InterlineOfferResponsePayloadType::setBaggageDisclosureList()
     * @uses InterlineOfferResponsePayloadType::setDatedMarketingSegmentList()
     * @uses InterlineOfferResponsePayloadType::setDatedOperatingLegList()
     * @uses InterlineOfferResponsePayloadType::setDatedOperatingSegmentList()
     * @uses InterlineOfferResponsePayloadType::setDisclosureList()
     * @uses InterlineOfferResponsePayloadType::setInterlineOffers()
     * @uses InterlineOfferResponsePayloadType::setMarketingMessage()
     * @uses InterlineOfferResponsePayloadType::setOptionalOffers()
     * @uses InterlineOfferResponsePayloadType::setPaxJourneyList()
     * @uses InterlineOfferResponsePayloadType::setPaxList()
     * @uses InterlineOfferResponsePayloadType::setPaxSegmentList()
     * @uses InterlineOfferResponsePayloadType::setServiceDefinitionList()
     * @uses InterlineOfferResponsePayloadType::setWarning()
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @param \StructType\DisclosureListType $disclosureList
     * @param \StructType\SupplierOfferType[] $interlineOffers
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @param \StructType\InterlineALaCarteOfferType[] $optionalOffers
     * @param \StructType\PaxJourneyListType $paxJourneyList
     * @param \StructType\PaxListType $paxList
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(\StructType\BaggageAllowanceListType $baggageAllowanceList = null, \StructType\BaggageDisclosureListType $baggageDisclosureList = null, array $datedMarketingSegmentList = array(), array $datedOperatingLegList = array(), array $datedOperatingSegmentList = array(), \StructType\DisclosureListType $disclosureList = null, array $interlineOffers = array(), array $marketingMessage = array(), array $optionalOffers = array(), \StructType\PaxJourneyListType $paxJourneyList = null, \StructType\PaxListType $paxList = null, \StructType\PaxSegmentListType $paxSegmentList = null, \StructType\ServiceDefinitionListType $serviceDefinitionList = null, array $warning = array())
    {
        $this
            ->setBaggageAllowanceList($baggageAllowanceList)
            ->setBaggageDisclosureList($baggageDisclosureList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setDisclosureList($disclosureList)
            ->setInterlineOffers($interlineOffers)
            ->setMarketingMessage($marketingMessage)
            ->setOptionalOffers($optionalOffers)
            ->setPaxJourneyList($paxJourneyList)
            ->setPaxList($paxList)
            ->setPaxSegmentList($paxSegmentList)
            ->setServiceDefinitionList($serviceDefinitionList)
            ->setWarning($warning);
    }
    /**
     * Get BaggageAllowanceList value
     * @return \StructType\BaggageAllowanceListType|null
     */
    public function getBaggageAllowanceList()
    {
        return $this->BaggageAllowanceList;
    }
    /**
     * Set BaggageAllowanceList value
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setBaggageAllowanceList(\StructType\BaggageAllowanceListType $baggageAllowanceList = null)
    {
        $this->BaggageAllowanceList = $baggageAllowanceList;
        return $this;
    }
    /**
     * Get BaggageDisclosureList value
     * @return \StructType\BaggageDisclosureListType|null
     */
    public function getBaggageDisclosureList()
    {
        return $this->BaggageDisclosureList;
    }
    /**
     * Set BaggageDisclosureList value
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setBaggageDisclosureList(\StructType\BaggageDisclosureListType $baggageDisclosureList = null)
    {
        $this->BaggageDisclosureList = $baggageDisclosureList;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType[]|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem instanceof \StructType\DatedMarketingSegmentListType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem) ? get_class($interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem), var_export($interlineOfferResponsePayloadTypeDatedMarketingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setDatedMarketingSegmentList(array $datedMarketingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentListArrayErrorMessage = self::validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList($datedMarketingSegmentList))) {
            throw new \InvalidArgumentException($datedMarketingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType[]|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeDatedOperatingLegListItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeDatedOperatingLegListItem instanceof \StructType\DatedOperatingLegListType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeDatedOperatingLegListItem) ? get_class($interlineOfferResponsePayloadTypeDatedOperatingLegListItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeDatedOperatingLegListItem), var_export($interlineOfferResponsePayloadTypeDatedOperatingLegListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setDatedOperatingLegList(array $datedOperatingLegList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegListArrayErrorMessage = self::validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList($datedOperatingLegList))) {
            throw new \InvalidArgumentException($datedOperatingLegListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToDatedOperatingLegList(\StructType\DatedOperatingLegListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingLegListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType[]|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem instanceof \StructType\DatedOperatingSegmentListType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem) ? get_class($interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem), var_export($interlineOfferResponsePayloadTypeDatedOperatingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setDatedOperatingSegmentList(array $datedOperatingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingSegmentListArrayErrorMessage = self::validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList($datedOperatingSegmentList))) {
            throw new \InvalidArgumentException($datedOperatingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * Set DisclosureList value
     * @param \StructType\DisclosureListType $disclosureList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setDisclosureList(\StructType\DisclosureListType $disclosureList = null)
    {
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Get InterlineOffers value
     * @return \StructType\SupplierOfferType[]|null
     */
    public function getInterlineOffers()
    {
        return $this->InterlineOffers;
    }
    /**
     * This method is responsible for validating the values passed to the setInterlineOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterlineOffers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterlineOffersForArrayConstraintsFromSetInterlineOffers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeInterlineOffersItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeInterlineOffersItem instanceof \StructType\SupplierOfferType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeInterlineOffersItem) ? get_class($interlineOfferResponsePayloadTypeInterlineOffersItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeInterlineOffersItem), var_export($interlineOfferResponsePayloadTypeInterlineOffersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InterlineOffers property can only contain items of type \StructType\SupplierOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InterlineOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferType[] $interlineOffers
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setInterlineOffers(array $interlineOffers = array())
    {
        // validation for constraint: array
        if ('' !== ($interlineOffersArrayErrorMessage = self::validateInterlineOffersForArrayConstraintsFromSetInterlineOffers($interlineOffers))) {
            throw new \InvalidArgumentException($interlineOffersArrayErrorMessage, __LINE__);
        }
        $this->InterlineOffers = $interlineOffers;
        return $this;
    }
    /**
     * Add item to InterlineOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOfferType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToInterlineOffers(\StructType\SupplierOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierOfferType) {
            throw new \InvalidArgumentException(sprintf('The InterlineOffers property can only contain items of type \StructType\SupplierOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InterlineOffers[] = $item;
        return $this;
    }
    /**
     * Get MarketingMessage value
     * @return \StructType\MarketingMessageType[]|null
     */
    public function getMarketingMessage()
    {
        return $this->MarketingMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingMessageForArrayConstraintsFromSetMarketingMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeMarketingMessageItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeMarketingMessageItem instanceof \StructType\MarketingMessageType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeMarketingMessageItem) ? get_class($interlineOfferResponsePayloadTypeMarketingMessageItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeMarketingMessageItem), var_export($interlineOfferResponsePayloadTypeMarketingMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setMarketingMessage(array $marketingMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingMessageArrayErrorMessage = self::validateMarketingMessageForArrayConstraintsFromSetMarketingMessage($marketingMessage))) {
            throw new \InvalidArgumentException($marketingMessageArrayErrorMessage, __LINE__);
        }
        $this->MarketingMessage = $marketingMessage;
        return $this;
    }
    /**
     * Add item to MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToMarketingMessage(\StructType\MarketingMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingMessageType) {
            throw new \InvalidArgumentException(sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingMessage[] = $item;
        return $this;
    }
    /**
     * Get OptionalOffers value
     * @return \StructType\InterlineALaCarteOfferType[]|null
     */
    public function getOptionalOffers()
    {
        return $this->OptionalOffers;
    }
    /**
     * This method is responsible for validating the values passed to the setOptionalOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptionalOffers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionalOffersForArrayConstraintsFromSetOptionalOffers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeOptionalOffersItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeOptionalOffersItem instanceof \StructType\InterlineALaCarteOfferType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeOptionalOffersItem) ? get_class($interlineOfferResponsePayloadTypeOptionalOffersItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeOptionalOffersItem), var_export($interlineOfferResponsePayloadTypeOptionalOffersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OptionalOffers property can only contain items of type \StructType\InterlineALaCarteOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OptionalOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineALaCarteOfferType[] $optionalOffers
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setOptionalOffers(array $optionalOffers = array())
    {
        // validation for constraint: array
        if ('' !== ($optionalOffersArrayErrorMessage = self::validateOptionalOffersForArrayConstraintsFromSetOptionalOffers($optionalOffers))) {
            throw new \InvalidArgumentException($optionalOffersArrayErrorMessage, __LINE__);
        }
        $this->OptionalOffers = $optionalOffers;
        return $this;
    }
    /**
     * Add item to OptionalOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineALaCarteOfferType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToOptionalOffers(\StructType\InterlineALaCarteOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineALaCarteOfferType) {
            throw new \InvalidArgumentException(sprintf('The OptionalOffers property can only contain items of type \StructType\InterlineALaCarteOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OptionalOffers[] = $item;
        return $this;
    }
    /**
     * Get PaxJourneyList value
     * @return \StructType\PaxJourneyListType|null
     */
    public function getPaxJourneyList()
    {
        return $this->PaxJourneyList;
    }
    /**
     * Set PaxJourneyList value
     * @param \StructType\PaxJourneyListType $paxJourneyList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setPaxJourneyList(\StructType\PaxJourneyListType $paxJourneyList = null)
    {
        $this->PaxJourneyList = $paxJourneyList;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get PaxSegmentList value
     * @return \StructType\PaxSegmentListType|null
     */
    public function getPaxSegmentList()
    {
        return $this->PaxSegmentList;
    }
    /**
     * Set PaxSegmentList value
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setPaxSegmentList(\StructType\PaxSegmentListType $paxSegmentList = null)
    {
        $this->PaxSegmentList = $paxSegmentList;
        return $this;
    }
    /**
     * Get ServiceDefinitionList value
     * @return \StructType\ServiceDefinitionListType|null
     */
    public function getServiceDefinitionList()
    {
        return $this->ServiceDefinitionList;
    }
    /**
     * Set ServiceDefinitionList value
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setServiceDefinitionList(\StructType\ServiceDefinitionListType $serviceDefinitionList = null)
    {
        $this->ServiceDefinitionList = $serviceDefinitionList;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferResponsePayloadTypeWarningItem) {
            // validation for constraint: itemType
            if (!$interlineOfferResponsePayloadTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($interlineOfferResponsePayloadTypeWarningItem) ? get_class($interlineOfferResponsePayloadTypeWarningItem) : sprintf('%s(%s)', gettype($interlineOfferResponsePayloadTypeWarningItem), var_export($interlineOfferResponsePayloadTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\InterlineOfferResponsePayloadType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
