<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOfferQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: A node used to allow selection of itinerary or/and a selection of offers.
 * @subpackage Structs
 */
class InterlineOfferQueryType extends AbstractStructBase
{
    /**
     * The Itineray
     * Meta information extracted from the WSDL
     * - documentation: This is a container for a flight request type which allow multiple Origin and Destination flight criteria to be input in this type of request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public $Itineray;
    /**
     * The SelectedOfferList
     * Meta information extracted from the WSDL
     * - documentation: This is a collection of Selected Offer's
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedOfferListType[]
     */
    public $SelectedOfferList;
    /**
     * Constructor method for InterlineOfferQueryType
     * @uses InterlineOfferQueryType::setItineray()
     * @uses InterlineOfferQueryType::setSelectedOfferList()
     * @param \StructType\InterlineFlightRequestOriginDestinationsCriteriaType $itineray
     * @param \StructType\SelectedOfferListType[] $selectedOfferList
     */
    public function __construct(\StructType\InterlineFlightRequestOriginDestinationsCriteriaType $itineray = null, array $selectedOfferList = array())
    {
        $this
            ->setItineray($itineray)
            ->setSelectedOfferList($selectedOfferList);
    }
    /**
     * Get Itineray value
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType|null
     */
    public function getItineray()
    {
        return $this->Itineray;
    }
    /**
     * Set Itineray value
     * @param \StructType\InterlineFlightRequestOriginDestinationsCriteriaType $itineray
     * @return \StructType\InterlineOfferQueryType
     */
    public function setItineray(\StructType\InterlineFlightRequestOriginDestinationsCriteriaType $itineray = null)
    {
        $this->Itineray = $itineray;
        return $this;
    }
    /**
     * Get SelectedOfferList value
     * @return \StructType\SelectedOfferListType[]|null
     */
    public function getSelectedOfferList()
    {
        return $this->SelectedOfferList;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOfferList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOfferList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOfferListForArrayConstraintsFromSetSelectedOfferList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferQueryTypeSelectedOfferListItem) {
            // validation for constraint: itemType
            if (!$interlineOfferQueryTypeSelectedOfferListItem instanceof \StructType\SelectedOfferListType) {
                $invalidValues[] = is_object($interlineOfferQueryTypeSelectedOfferListItem) ? get_class($interlineOfferQueryTypeSelectedOfferListItem) : sprintf('%s(%s)', gettype($interlineOfferQueryTypeSelectedOfferListItem), var_export($interlineOfferQueryTypeSelectedOfferListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOfferList property can only contain items of type \StructType\SelectedOfferListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOfferList value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferListType[] $selectedOfferList
     * @return \StructType\InterlineOfferQueryType
     */
    public function setSelectedOfferList(array $selectedOfferList = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOfferListArrayErrorMessage = self::validateSelectedOfferListForArrayConstraintsFromSetSelectedOfferList($selectedOfferList))) {
            throw new \InvalidArgumentException($selectedOfferListArrayErrorMessage, __LINE__);
        }
        $this->SelectedOfferList = $selectedOfferList;
        return $this;
    }
    /**
     * Add item to SelectedOfferList value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferListType $item
     * @return \StructType\InterlineOfferQueryType
     */
    public function addToSelectedOfferList(\StructType\SelectedOfferListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOfferListType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOfferList property can only contain items of type \StructType\SelectedOfferListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOfferList[] = $item;
        return $this;
    }
}
