<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineFlightRequestOriginDestinationsCriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a container for a flight request type which allow multiple Origin and Destination flight criteria to be input in this type of request.
 * @subpackage Structs
 */
class InterlineFlightRequestOriginDestinationsCriteriaType extends AbstractStructBase
{
    /**
     * The JourneyDurationCriteria
     * Meta information extracted from the WSDL
     * - documentation: Total journey travel time per bound preferences. This includes the sum of all flight durations as well as connection times.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JourneyDurationCriteriaType[]
     */
    public $JourneyDurationCriteria;
    /**
     * The OriginDestCriteria
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineOriginDestCriteriaType[]
     */
    public $OriginDestCriteria;
    /**
     * Constructor method for InterlineFlightRequestOriginDestinationsCriteriaType
     * @uses InterlineFlightRequestOriginDestinationsCriteriaType::setJourneyDurationCriteria()
     * @uses InterlineFlightRequestOriginDestinationsCriteriaType::setOriginDestCriteria()
     * @param \StructType\JourneyDurationCriteriaType[] $journeyDurationCriteria
     * @param \StructType\InterlineOriginDestCriteriaType[] $originDestCriteria
     */
    public function __construct(array $journeyDurationCriteria = array(), array $originDestCriteria = array())
    {
        $this
            ->setJourneyDurationCriteria($journeyDurationCriteria)
            ->setOriginDestCriteria($originDestCriteria);
    }
    /**
     * Get JourneyDurationCriteria value
     * @return \StructType\JourneyDurationCriteriaType[]|null
     */
    public function getJourneyDurationCriteria()
    {
        return $this->JourneyDurationCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setJourneyDurationCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJourneyDurationCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJourneyDurationCriteriaForArrayConstraintsFromSetJourneyDurationCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem instanceof \StructType\JourneyDurationCriteriaType) {
                $invalidValues[] = is_object($interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem) ? get_class($interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem) : sprintf('%s(%s)', gettype($interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem), var_export($interlineFlightRequestOriginDestinationsCriteriaTypeJourneyDurationCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JourneyDurationCriteria property can only contain items of type \StructType\JourneyDurationCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JourneyDurationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyDurationCriteriaType[] $journeyDurationCriteria
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public function setJourneyDurationCriteria(array $journeyDurationCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($journeyDurationCriteriaArrayErrorMessage = self::validateJourneyDurationCriteriaForArrayConstraintsFromSetJourneyDurationCriteria($journeyDurationCriteria))) {
            throw new \InvalidArgumentException($journeyDurationCriteriaArrayErrorMessage, __LINE__);
        }
        $this->JourneyDurationCriteria = $journeyDurationCriteria;
        return $this;
    }
    /**
     * Add item to JourneyDurationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyDurationCriteriaType $item
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public function addToJourneyDurationCriteria(\StructType\JourneyDurationCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JourneyDurationCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The JourneyDurationCriteria property can only contain items of type \StructType\JourneyDurationCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JourneyDurationCriteria[] = $item;
        return $this;
    }
    /**
     * Get OriginDestCriteria value
     * @return \StructType\InterlineOriginDestCriteriaType[]|null
     */
    public function getOriginDestCriteria()
    {
        return $this->OriginDestCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestCriteriaForArrayConstraintsFromSetOriginDestCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem instanceof \StructType\InterlineOriginDestCriteriaType) {
                $invalidValues[] = is_object($interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) ? get_class($interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem) : sprintf('%s(%s)', gettype($interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem), var_export($interlineFlightRequestOriginDestinationsCriteriaTypeOriginDestCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestCriteria property can only contain items of type \StructType\InterlineOriginDestCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineOriginDestCriteriaType[] $originDestCriteria
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public function setOriginDestCriteria(array $originDestCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestCriteriaArrayErrorMessage = self::validateOriginDestCriteriaForArrayConstraintsFromSetOriginDestCriteria($originDestCriteria))) {
            throw new \InvalidArgumentException($originDestCriteriaArrayErrorMessage, __LINE__);
        }
        $this->OriginDestCriteria = $originDestCriteria;
        return $this;
    }
    /**
     * Add item to OriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineOriginDestCriteriaType $item
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public function addToOriginDestCriteria(\StructType\InterlineOriginDestCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineOriginDestCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The OriginDestCriteria property can only contain items of type \StructType\InterlineOriginDestCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginDestCriteria[] = $item;
        return $this;
    }
}
