<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_PayloadStandardAttributesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The IATA_PayloadStdAttributes defines the standard attributes that appear on the root element for all IATA payloads.
 * @subpackage Structs
 */
class IATA_PayloadStandardAttributesType extends AbstractStructBase
{
    /**
     * The AltLangID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the alternate language for a customer or message. The human language is identified by ISO 639 codes. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AltLangID;
    /**
     * The CorrelationID
     * Meta information extracted from the WSDL
     * - documentation: Allow end-to-end correlation of log messages with the corresponding Web service message throughout the processing of the Web service message. | An identifier is a character string used to uniquely identify one instance of an object
     * within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * Meta information extracted from the WSDL
     * - documentation: Identifes the primary language preference for the message. The human language is identified by ISO 639 codes. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The RetransmissionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to true) only when a message is retransmitted. | An indicator is a list of two mutually exclusive Boolean
     * values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RetransmissionInd;
    /**
     * The SeqNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has
     * been off-line and needs to retrieve messages that were missed. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $SeqNumber;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in UTC. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Timestamp;
    /**
     * The TrxID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to relate all messages within a transaction (e.g. this would be sent in all request and response messages that are part of an on-going transaction). | An identifier is a character string used to uniquely identify
     * one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrxID;
    /**
     * The VersionNumber
     * Meta information extracted from the WSDL
     * - documentation: For all IATA versioned messages, the version of the message is indicated by a decimal value. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $VersionNumber;
    /**
     * Constructor method for IATA_PayloadStandardAttributesType
     * @uses IATA_PayloadStandardAttributesType::setAltLangID()
     * @uses IATA_PayloadStandardAttributesType::setCorrelationID()
     * @uses IATA_PayloadStandardAttributesType::setPrimaryLangID()
     * @uses IATA_PayloadStandardAttributesType::setRetransmissionInd()
     * @uses IATA_PayloadStandardAttributesType::setSeqNumber()
     * @uses IATA_PayloadStandardAttributesType::setTimestamp()
     * @uses IATA_PayloadStandardAttributesType::setTrxID()
     * @uses IATA_PayloadStandardAttributesType::setVersionNumber()
     * @param string $altLangID
     * @param string $correlationID
     * @param string $primaryLangID
     * @param bool $retransmissionInd
     * @param float $seqNumber
     * @param string $timestamp
     * @param string $trxID
     * @param float $versionNumber
     */
    public function __construct($altLangID = null, $correlationID = null, $primaryLangID = null, $retransmissionInd = null, $seqNumber = null, $timestamp = null, $trxID = null, $versionNumber = null)
    {
        $this
            ->setAltLangID($altLangID)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setRetransmissionInd($retransmissionInd)
            ->setSeqNumber($seqNumber)
            ->setTimestamp($timestamp)
            ->setTrxID($trxID)
            ->setVersionNumber($versionNumber);
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get RetransmissionInd value
     * @return bool|null
     */
    public function getRetransmissionInd()
    {
        return $this->RetransmissionInd;
    }
    /**
     * Set RetransmissionInd value
     * @param bool $retransmissionInd
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setRetransmissionInd($retransmissionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionInd) && !is_bool($retransmissionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionInd, true), gettype($retransmissionInd)), __LINE__);
        }
        $this->RetransmissionInd = $retransmissionInd;
        return $this;
    }
    /**
     * Get SeqNumber value
     * @return float|null
     */
    public function getSeqNumber()
    {
        return $this->SeqNumber;
    }
    /**
     * Set SeqNumber value
     * @param float $seqNumber
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setSeqNumber($seqNumber = null)
    {
        // validation for constraint: float
        if (!is_null($seqNumber) && !(is_float($seqNumber) || is_numeric($seqNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($seqNumber, true), gettype($seqNumber)), __LINE__);
        }
        $this->SeqNumber = $seqNumber;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get TrxID value
     * @return string|null
     */
    public function getTrxID()
    {
        return $this->TrxID;
    }
    /**
     * Set TrxID value
     * @param string $trxID
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setTrxID($trxID = null)
    {
        // validation for constraint: string
        if (!is_null($trxID) && !is_string($trxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trxID, true), gettype($trxID)), __LINE__);
        }
        $this->TrxID = $trxID;
        return $this;
    }
    /**
     * Get VersionNumber value
     * @return float|null
     */
    public function getVersionNumber()
    {
        return $this->VersionNumber;
    }
    /**
     * Set VersionNumber value
     * @param float $versionNumber
     * @return \StructType\IATA_PayloadStandardAttributesType
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: float
        if (!is_null($versionNumber) && !(is_float($versionNumber) || is_numeric($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        $this->VersionNumber = $versionNumber;
        return $this;
    }
}
