<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_EasyPayType StructType
 * Meta information extracted from the WSDL
 * - documentation: IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
 * @subpackage Structs
 */
class IATA_EasyPayType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The 16 digit EasyPay account number. | Data type for Payment Card Number.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9X]{1,19}
     * @var string
     */
    public $AccountNumber;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: The last month of validity Example 0119. | BDT used to define card issue/expiry dates in a 4N format.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IATA_EasyPayEncryptedData
     * Meta information extracted from the WSDL
     * - documentation: container for the encrypted Easy Pay data
     * - minOccurs: 0
     * @var \StructType\IATA_EasyPayEncryptedDataType
     */
    public $IATA_EasyPayEncryptedData;
    /**
     * The SettlementData
     * Meta information extracted from the WSDL
     * - documentation: Amounts that define the funds to be cleared as a result of the payment commitment and the selected payment method, and the date when the funds must be remitted.
     * - minOccurs: 0
     * @var \StructType\SettlementDataType
     */
    public $SettlementData;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - documentation: Authorization result Approval code | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovalCode;
    /**
     * Constructor method for IATA_EasyPayType
     * @uses IATA_EasyPayType::setAccountNumber()
     * @uses IATA_EasyPayType::setExpirationDate()
     * @uses IATA_EasyPayType::setIATA_EasyPayEncryptedData()
     * @uses IATA_EasyPayType::setSettlementData()
     * @uses IATA_EasyPayType::setApprovalCode()
     * @param string $accountNumber
     * @param string $expirationDate
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     * @param \StructType\SettlementDataType $settlementData
     * @param string $approvalCode
     */
    public function __construct($accountNumber = null, $expirationDate = null, \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null, \StructType\SettlementDataType $settlementData = null, $approvalCode = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setExpirationDate($expirationDate)
            ->setIATA_EasyPayEncryptedData($iATA_EasyPayEncryptedData)
            ->setSettlementData($settlementData)
            ->setApprovalCode($approvalCode);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\IATA_EasyPayType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9X]{1,19})
        if (!is_null($accountNumber) && !preg_match('/[0-9X]{1,19}/', $accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9X]{1,19}', var_export($accountNumber, true)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\IATA_EasyPayType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($expirationDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($expirationDate, true)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get IATA_EasyPayEncryptedData value
     * @return \StructType\IATA_EasyPayEncryptedDataType|null
     */
    public function getIATA_EasyPayEncryptedData()
    {
        return $this->IATA_EasyPayEncryptedData;
    }
    /**
     * Set IATA_EasyPayEncryptedData value
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     * @return \StructType\IATA_EasyPayType
     */
    public function setIATA_EasyPayEncryptedData(\StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null)
    {
        $this->IATA_EasyPayEncryptedData = $iATA_EasyPayEncryptedData;
        return $this;
    }
    /**
     * Get SettlementData value
     * @return \StructType\SettlementDataType|null
     */
    public function getSettlementData()
    {
        return $this->SettlementData;
    }
    /**
     * Set SettlementData value
     * @param \StructType\SettlementDataType $settlementData
     * @return \StructType\IATA_EasyPayType
     */
    public function setSettlementData(\StructType\SettlementDataType $settlementData = null)
    {
        $this->SettlementData = $settlementData;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\IATA_EasyPayType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
}
