<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_EasyPayEncryptedDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: container for the encrypted Easy Pay data
 * @subpackage Structs
 */
class IATA_EasyPayEncryptedDataType extends AbstractStructBase
{
    /**
     * The EncryptedAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Tokenized EasyPay Account number | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $EncryptedAccountNumber;
    /**
     * The KeyNameText
     * Meta information extracted from the WSDL
     * - documentation: encryption key | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyNameText;
    /**
     * Constructor method for IATA_EasyPayEncryptedDataType
     * @uses IATA_EasyPayEncryptedDataType::setEncryptedAccountNumber()
     * @uses IATA_EasyPayEncryptedDataType::setKeyNameText()
     * @param float $encryptedAccountNumber
     * @param string $keyNameText
     */
    public function __construct($encryptedAccountNumber = null, $keyNameText = null)
    {
        $this
            ->setEncryptedAccountNumber($encryptedAccountNumber)
            ->setKeyNameText($keyNameText);
    }
    /**
     * Get EncryptedAccountNumber value
     * @return float|null
     */
    public function getEncryptedAccountNumber()
    {
        return $this->EncryptedAccountNumber;
    }
    /**
     * Set EncryptedAccountNumber value
     * @param float $encryptedAccountNumber
     * @return \StructType\IATA_EasyPayEncryptedDataType
     */
    public function setEncryptedAccountNumber($encryptedAccountNumber = null)
    {
        // validation for constraint: float
        if (!is_null($encryptedAccountNumber) && !(is_float($encryptedAccountNumber) || is_numeric($encryptedAccountNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($encryptedAccountNumber, true), gettype($encryptedAccountNumber)), __LINE__);
        }
        $this->EncryptedAccountNumber = $encryptedAccountNumber;
        return $this;
    }
    /**
     * Get KeyNameText value
     * @return string|null
     */
    public function getKeyNameText()
    {
        return $this->KeyNameText;
    }
    /**
     * Set KeyNameText value
     * @param string $keyNameText
     * @return \StructType\IATA_EasyPayEncryptedDataType
     */
    public function setKeyNameText($keyNameText = null)
    {
        // validation for constraint: string
        if (!is_null($keyNameText) && !is_string($keyNameText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyNameText, true), gettype($keyNameText)), __LINE__);
        }
        $this->KeyNameText = $keyNameText;
        return $this;
    }
}
