<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeographicFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Criteria used to filter results based on geographic preferences, including Area, State, City, Airport, or Geospatial information.
 * @subpackage Structs
 */
class GeographicFilterCriteriaType extends AbstractStructBase
{
    /**
     * The AreaCodeText
     * Meta information extracted from the WSDL
     * - documentation: Valid area values include 1 = Western Hemisphere 2 = Europe, Africa, and the Near East 3 = Far East, Australia, and Pacific | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaCodeText;
    /**
     * The CoordRadiusMeasure
     * Meta information extracted from the WSDL
     * - documentation: Radius to be used in conjunction with associated Geospatial coordinates.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $CoordRadiusMeasure;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The CountrySubDivisionCode
     * Meta information extracted from the WSDL
     * - documentation: The ISO code identifying this country sub-division within a given country. E.g. 'AZ' for state of Arizona (US), 'BY' for region of Bavaria (Germany). | The list of Country Sub-Division Codes in ISO 3166-2, or referenced from ISO
     * 3166-2 for the specific countries. Max-3-char sub-division code without preceding country code. | ISO 3166-2 Country Sub-Division Code. Max-3-char sub-division code without preceding country code. E.g. 'AZ' for Arizona, 'BY' for Bavaria region in
     * Germany.
     * - base: CountrySubDivisionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountrySubDivisionCode;
    /**
     * The GeospatialLocation
     * Meta information extracted from the WSDL
     * - documentation: A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeospatialLocationType
     */
    public $GeospatialLocation;
    /**
     * The IATA_LocationCode
     * Meta information extracted from the WSDL
     * - documentation: IATA defined code identifying a city or station. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATA_LocationCode;
    /**
     * Constructor method for GeographicFilterCriteriaType
     * @uses GeographicFilterCriteriaType::setAreaCodeText()
     * @uses GeographicFilterCriteriaType::setCoordRadiusMeasure()
     * @uses GeographicFilterCriteriaType::setCountryCode()
     * @uses GeographicFilterCriteriaType::setCountrySubDivisionCode()
     * @uses GeographicFilterCriteriaType::setGeospatialLocation()
     * @uses GeographicFilterCriteriaType::setIATA_LocationCode()
     * @param string $areaCodeText
     * @param \StructType\MeasureType $coordRadiusMeasure
     * @param string $countryCode
     * @param string $countrySubDivisionCode
     * @param \StructType\GeospatialLocationType $geospatialLocation
     * @param string $iATA_LocationCode
     */
    public function __construct($areaCodeText = null, \StructType\MeasureType $coordRadiusMeasure = null, $countryCode = null, $countrySubDivisionCode = null, \StructType\GeospatialLocationType $geospatialLocation = null, $iATA_LocationCode = null)
    {
        $this
            ->setAreaCodeText($areaCodeText)
            ->setCoordRadiusMeasure($coordRadiusMeasure)
            ->setCountryCode($countryCode)
            ->setCountrySubDivisionCode($countrySubDivisionCode)
            ->setGeospatialLocation($geospatialLocation)
            ->setIATA_LocationCode($iATA_LocationCode);
    }
    /**
     * Get AreaCodeText value
     * @return string|null
     */
    public function getAreaCodeText()
    {
        return $this->AreaCodeText;
    }
    /**
     * Set AreaCodeText value
     * @param string $areaCodeText
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setAreaCodeText($areaCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($areaCodeText) && !is_string($areaCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCodeText, true), gettype($areaCodeText)), __LINE__);
        }
        $this->AreaCodeText = $areaCodeText;
        return $this;
    }
    /**
     * Get CoordRadiusMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getCoordRadiusMeasure()
    {
        return $this->CoordRadiusMeasure;
    }
    /**
     * Set CoordRadiusMeasure value
     * @param \StructType\MeasureType $coordRadiusMeasure
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setCoordRadiusMeasure(\StructType\MeasureType $coordRadiusMeasure = null)
    {
        $this->CoordRadiusMeasure = $coordRadiusMeasure;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[A-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CountrySubDivisionCode value
     * @return string|null
     */
    public function getCountrySubDivisionCode()
    {
        return $this->CountrySubDivisionCode;
    }
    /**
     * Set CountrySubDivisionCode value
     * @param string $countrySubDivisionCode
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setCountrySubDivisionCode($countrySubDivisionCode = null)
    {
        // validation for constraint: string
        if (!is_null($countrySubDivisionCode) && !is_string($countrySubDivisionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySubDivisionCode, true), gettype($countrySubDivisionCode)), __LINE__);
        }
        $this->CountrySubDivisionCode = $countrySubDivisionCode;
        return $this;
    }
    /**
     * Get GeospatialLocation value
     * @return \StructType\GeospatialLocationType|null
     */
    public function getGeospatialLocation()
    {
        return $this->GeospatialLocation;
    }
    /**
     * Set GeospatialLocation value
     * @param \StructType\GeospatialLocationType $geospatialLocation
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setGeospatialLocation(\StructType\GeospatialLocationType $geospatialLocation = null)
    {
        $this->GeospatialLocation = $geospatialLocation;
        return $this;
    }
    /**
     * Get IATA_LocationCode value
     * @return string|null
     */
    public function getIATA_LocationCode()
    {
        return $this->IATA_LocationCode;
    }
    /**
     * Set IATA_LocationCode value
     * @param string $iATA_LocationCode
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function setIATA_LocationCode($iATA_LocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_LocationCode) && !is_string($iATA_LocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_LocationCode, true), gettype($iATA_LocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($iATA_LocationCode) && mb_strlen($iATA_LocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($iATA_LocationCode)), __LINE__);
        }
        $this->IATA_LocationCode = $iATA_LocationCode;
        return $this;
    }
}
