<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: List the object intended to be associated within this message.
 * @subpackage Structs
 */
class GeneralAssociationType extends AbstractStructBase
{
    /**
     * The AssociatedObjectID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the object intended to be associated within this message. E.g. PAX001 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssociatedObjectID;
    /**
     * The AssociatedObjectName
     * Meta information extracted from the WSDL
     * - documentation: Name of the object intended to be associated. E.g. Passenger | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssociatedObjectName;
    /**
     * The AssociatedObjectPath
     * Meta information extracted from the WSDL
     * - documentation: XPath to the object intended to be associated within this message. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssociatedObjectPath;
    /**
     * Constructor method for GeneralAssociationType
     * @uses GeneralAssociationType::setAssociatedObjectID()
     * @uses GeneralAssociationType::setAssociatedObjectName()
     * @uses GeneralAssociationType::setAssociatedObjectPath()
     * @param string $associatedObjectID
     * @param string $associatedObjectName
     * @param string $associatedObjectPath
     */
    public function __construct($associatedObjectID = null, $associatedObjectName = null, $associatedObjectPath = null)
    {
        $this
            ->setAssociatedObjectID($associatedObjectID)
            ->setAssociatedObjectName($associatedObjectName)
            ->setAssociatedObjectPath($associatedObjectPath);
    }
    /**
     * Get AssociatedObjectID value
     * @return string|null
     */
    public function getAssociatedObjectID()
    {
        return $this->AssociatedObjectID;
    }
    /**
     * Set AssociatedObjectID value
     * @param string $associatedObjectID
     * @return \StructType\GeneralAssociationType
     */
    public function setAssociatedObjectID($associatedObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($associatedObjectID) && !is_string($associatedObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedObjectID, true), gettype($associatedObjectID)), __LINE__);
        }
        $this->AssociatedObjectID = $associatedObjectID;
        return $this;
    }
    /**
     * Get AssociatedObjectName value
     * @return string|null
     */
    public function getAssociatedObjectName()
    {
        return $this->AssociatedObjectName;
    }
    /**
     * Set AssociatedObjectName value
     * @param string $associatedObjectName
     * @return \StructType\GeneralAssociationType
     */
    public function setAssociatedObjectName($associatedObjectName = null)
    {
        // validation for constraint: string
        if (!is_null($associatedObjectName) && !is_string($associatedObjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedObjectName, true), gettype($associatedObjectName)), __LINE__);
        }
        $this->AssociatedObjectName = $associatedObjectName;
        return $this;
    }
    /**
     * Get AssociatedObjectPath value
     * @return string|null
     */
    public function getAssociatedObjectPath()
    {
        return $this->AssociatedObjectPath;
    }
    /**
     * Set AssociatedObjectPath value
     * @param string $associatedObjectPath
     * @return \StructType\GeneralAssociationType
     */
    public function setAssociatedObjectPath($associatedObjectPath = null)
    {
        // validation for constraint: string
        if (!is_null($associatedObjectPath) && !is_string($associatedObjectPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedObjectPath, true), gettype($associatedObjectPath)), __LINE__);
        }
        $this->AssociatedObjectPath = $associatedObjectPath;
        return $this;
    }
}
