<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight Request
 * @subpackage Structs
 */
class FlightRequestType extends AbstractStructBase
{
    /**
     * The AffinityShoppingCriteria
     * Meta information extracted from the WSDL
     * - documentation: Affinity search includes a wide range of criteria including generic origin/destination information, trip time periods, as well as travel budget.
     * - choice: AffinityShoppingCriteria | FlightRequestOriginDestinationsCriteria | FlightRequestSpecificOriginDestinations
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AffinityShoppingCriteriaType
     */
    public $AffinityShoppingCriteria;
    /**
     * The FlightRequestOriginDestinationsCriteria
     * Meta information extracted from the WSDL
     * - documentation: This is a container for a flight request type which allow multiple Origin and Destination flight criteria to be input in this type of request.
     * - choice: AffinityShoppingCriteria | FlightRequestOriginDestinationsCriteria | FlightRequestSpecificOriginDestinations
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FlightRequestOriginDestinationsCriteriaType
     */
    public $FlightRequestOriginDestinationsCriteria;
    /**
     * The FlightRequestSpecificOriginDestinations
     * Meta information extracted from the WSDL
     * - documentation: This is a container for a flight request type which allow multiple specified origin and destinations to be input in this type of request.
     * - choice: AffinityShoppingCriteria | FlightRequestOriginDestinationsCriteria | FlightRequestSpecificOriginDestinations
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FlightRequestSpecificOriginDestinationsType
     */
    public $FlightRequestSpecificOriginDestinations;
    /**
     * Constructor method for FlightRequestType
     * @uses FlightRequestType::setAffinityShoppingCriteria()
     * @uses FlightRequestType::setFlightRequestOriginDestinationsCriteria()
     * @uses FlightRequestType::setFlightRequestSpecificOriginDestinations()
     * @param \StructType\AffinityShoppingCriteriaType $affinityShoppingCriteria
     * @param \StructType\FlightRequestOriginDestinationsCriteriaType $flightRequestOriginDestinationsCriteria
     * @param \StructType\FlightRequestSpecificOriginDestinationsType $flightRequestSpecificOriginDestinations
     */
    public function __construct(\StructType\AffinityShoppingCriteriaType $affinityShoppingCriteria = null, \StructType\FlightRequestOriginDestinationsCriteriaType $flightRequestOriginDestinationsCriteria = null, \StructType\FlightRequestSpecificOriginDestinationsType $flightRequestSpecificOriginDestinations = null)
    {
        $this
            ->setAffinityShoppingCriteria($affinityShoppingCriteria)
            ->setFlightRequestOriginDestinationsCriteria($flightRequestOriginDestinationsCriteria)
            ->setFlightRequestSpecificOriginDestinations($flightRequestSpecificOriginDestinations);
    }
    /**
     * Get AffinityShoppingCriteria value
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function getAffinityShoppingCriteria()
    {
        return isset($this->AffinityShoppingCriteria) ? $this->AffinityShoppingCriteria : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAffinityShoppingCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffinityShoppingCriteria method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAffinityShoppingCriteriaForChoiceConstraintsFromSetAffinityShoppingCriteria($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FlightRequestOriginDestinationsCriteria',
            'FlightRequestSpecificOriginDestinations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AffinityShoppingCriteria can\'t be set as the property %s is already set. Only one property must be set among these properties: AffinityShoppingCriteria, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AffinityShoppingCriteria value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AffinityShoppingCriteriaType $affinityShoppingCriteria
     * @return \StructType\FlightRequestType
     */
    public function setAffinityShoppingCriteria(\StructType\AffinityShoppingCriteriaType $affinityShoppingCriteria = null)
    {
        // validation for constraint: choice(AffinityShoppingCriteria, FlightRequestOriginDestinationsCriteria, FlightRequestSpecificOriginDestinations)
        if ('' !== ($affinityShoppingCriteriaChoiceErrorMessage = self::validateAffinityShoppingCriteriaForChoiceConstraintsFromSetAffinityShoppingCriteria($affinityShoppingCriteria))) {
            throw new \InvalidArgumentException($affinityShoppingCriteriaChoiceErrorMessage, __LINE__);
        }
        if (is_null($affinityShoppingCriteria) || (is_array($affinityShoppingCriteria) && empty($affinityShoppingCriteria))) {
            unset($this->AffinityShoppingCriteria);
        } else {
            $this->AffinityShoppingCriteria = $affinityShoppingCriteria;
        }
        return $this;
    }
    /**
     * Get FlightRequestOriginDestinationsCriteria value
     * @return \StructType\FlightRequestOriginDestinationsCriteriaType
     */
    public function getFlightRequestOriginDestinationsCriteria()
    {
        return isset($this->FlightRequestOriginDestinationsCriteria) ? $this->FlightRequestOriginDestinationsCriteria : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlightRequestOriginDestinationsCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRequestOriginDestinationsCriteria method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlightRequestOriginDestinationsCriteriaForChoiceConstraintsFromSetFlightRequestOriginDestinationsCriteria($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AffinityShoppingCriteria',
            'FlightRequestSpecificOriginDestinations',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlightRequestOriginDestinationsCriteria can\'t be set as the property %s is already set. Only one property must be set among these properties: FlightRequestOriginDestinationsCriteria, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlightRequestOriginDestinationsCriteria value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FlightRequestOriginDestinationsCriteriaType $flightRequestOriginDestinationsCriteria
     * @return \StructType\FlightRequestType
     */
    public function setFlightRequestOriginDestinationsCriteria(\StructType\FlightRequestOriginDestinationsCriteriaType $flightRequestOriginDestinationsCriteria = null)
    {
        // validation for constraint: choice(AffinityShoppingCriteria, FlightRequestOriginDestinationsCriteria, FlightRequestSpecificOriginDestinations)
        if ('' !== ($flightRequestOriginDestinationsCriteriaChoiceErrorMessage = self::validateFlightRequestOriginDestinationsCriteriaForChoiceConstraintsFromSetFlightRequestOriginDestinationsCriteria($flightRequestOriginDestinationsCriteria))) {
            throw new \InvalidArgumentException($flightRequestOriginDestinationsCriteriaChoiceErrorMessage, __LINE__);
        }
        if (is_null($flightRequestOriginDestinationsCriteria) || (is_array($flightRequestOriginDestinationsCriteria) && empty($flightRequestOriginDestinationsCriteria))) {
            unset($this->FlightRequestOriginDestinationsCriteria);
        } else {
            $this->FlightRequestOriginDestinationsCriteria = $flightRequestOriginDestinationsCriteria;
        }
        return $this;
    }
    /**
     * Get FlightRequestSpecificOriginDestinations value
     * @return \StructType\FlightRequestSpecificOriginDestinationsType
     */
    public function getFlightRequestSpecificOriginDestinations()
    {
        return isset($this->FlightRequestSpecificOriginDestinations) ? $this->FlightRequestSpecificOriginDestinations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlightRequestSpecificOriginDestinations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRequestSpecificOriginDestinations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlightRequestSpecificOriginDestinationsForChoiceConstraintsFromSetFlightRequestSpecificOriginDestinations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AffinityShoppingCriteria',
            'FlightRequestOriginDestinationsCriteria',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlightRequestSpecificOriginDestinations can\'t be set as the property %s is already set. Only one property must be set among these properties: FlightRequestSpecificOriginDestinations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlightRequestSpecificOriginDestinations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FlightRequestSpecificOriginDestinationsType $flightRequestSpecificOriginDestinations
     * @return \StructType\FlightRequestType
     */
    public function setFlightRequestSpecificOriginDestinations(\StructType\FlightRequestSpecificOriginDestinationsType $flightRequestSpecificOriginDestinations = null)
    {
        // validation for constraint: choice(AffinityShoppingCriteria, FlightRequestOriginDestinationsCriteria, FlightRequestSpecificOriginDestinations)
        if ('' !== ($flightRequestSpecificOriginDestinationsChoiceErrorMessage = self::validateFlightRequestSpecificOriginDestinationsForChoiceConstraintsFromSetFlightRequestSpecificOriginDestinations($flightRequestSpecificOriginDestinations))) {
            throw new \InvalidArgumentException($flightRequestSpecificOriginDestinationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($flightRequestSpecificOriginDestinations) || (is_array($flightRequestSpecificOriginDestinations) && empty($flightRequestSpecificOriginDestinations))) {
            unset($this->FlightRequestSpecificOriginDestinations);
        } else {
            $this->FlightRequestSpecificOriginDestinations = $flightRequestSpecificOriginDestinations;
        }
        return $this;
    }
}
