<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
 * @subpackage Structs
 */
class FlightCriteriaType extends AbstractStructBase
{
    /**
     * The FlightCharacteristicsCriteria
     * Meta information extracted from the WSDL
     * - documentation: When related to Flight Characteristics Criteria Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightCharacteristicsCriteriaType[]
     */
    public $FlightCharacteristicsCriteria;
    /**
     * The IATA_AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM. The same type may include aircrafts with different technical specifications such
     * as engines, range, cockpit configuration. Business Identifier Fields: - IATA Aircraft Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IATA_AircraftTypeType[]
     */
    public $IATA_AircraftType;
    /**
     * The RBD
     * Meta information extracted from the WSDL
     * - documentation: Reservation Booking Designator. A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium,
     * 'D' for Business Discounted. There will typically be several RBDs defined for a given Cabin Type. Business Identifier Fields: - RBD Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RBD_Type[]
     */
    public $RBD;
    /**
     * Constructor method for FlightCriteriaType
     * @uses FlightCriteriaType::setFlightCharacteristicsCriteria()
     * @uses FlightCriteriaType::setIATA_AircraftType()
     * @uses FlightCriteriaType::setRBD()
     * @param \StructType\FlightCharacteristicsCriteriaType[] $flightCharacteristicsCriteria
     * @param \StructType\IATA_AircraftTypeType[] $iATA_AircraftType
     * @param \StructType\RBD_Type[] $rBD
     */
    public function __construct(array $flightCharacteristicsCriteria = array(), array $iATA_AircraftType = array(), array $rBD = array())
    {
        $this
            ->setFlightCharacteristicsCriteria($flightCharacteristicsCriteria)
            ->setIATA_AircraftType($iATA_AircraftType)
            ->setRBD($rBD);
    }
    /**
     * Get FlightCharacteristicsCriteria value
     * @return \StructType\FlightCharacteristicsCriteriaType[]|null
     */
    public function getFlightCharacteristicsCriteria()
    {
        return $this->FlightCharacteristicsCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightCharacteristicsCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightCharacteristicsCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightCharacteristicsCriteriaForArrayConstraintsFromSetFlightCharacteristicsCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightCriteriaTypeFlightCharacteristicsCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightCriteriaTypeFlightCharacteristicsCriteriaItem instanceof \StructType\FlightCharacteristicsCriteriaType) {
                $invalidValues[] = is_object($flightCriteriaTypeFlightCharacteristicsCriteriaItem) ? get_class($flightCriteriaTypeFlightCharacteristicsCriteriaItem) : sprintf('%s(%s)', gettype($flightCriteriaTypeFlightCharacteristicsCriteriaItem), var_export($flightCriteriaTypeFlightCharacteristicsCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightCharacteristicsCriteria property can only contain items of type \StructType\FlightCharacteristicsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightCharacteristicsCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCharacteristicsCriteriaType[] $flightCharacteristicsCriteria
     * @return \StructType\FlightCriteriaType
     */
    public function setFlightCharacteristicsCriteria(array $flightCharacteristicsCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($flightCharacteristicsCriteriaArrayErrorMessage = self::validateFlightCharacteristicsCriteriaForArrayConstraintsFromSetFlightCharacteristicsCriteria($flightCharacteristicsCriteria))) {
            throw new \InvalidArgumentException($flightCharacteristicsCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FlightCharacteristicsCriteria = $flightCharacteristicsCriteria;
        return $this;
    }
    /**
     * Add item to FlightCharacteristicsCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCharacteristicsCriteriaType $item
     * @return \StructType\FlightCriteriaType
     */
    public function addToFlightCharacteristicsCriteria(\StructType\FlightCharacteristicsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightCharacteristicsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FlightCharacteristicsCriteria property can only contain items of type \StructType\FlightCharacteristicsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightCharacteristicsCriteria[] = $item;
        return $this;
    }
    /**
     * Get IATA_AircraftType value
     * @return \StructType\IATA_AircraftTypeType[]|null
     */
    public function getIATA_AircraftType()
    {
        return $this->IATA_AircraftType;
    }
    /**
     * This method is responsible for validating the values passed to the setIATA_AircraftType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIATA_AircraftType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIATA_AircraftTypeForArrayConstraintsFromSetIATA_AircraftType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightCriteriaTypeIATA_AircraftTypeItem) {
            // validation for constraint: itemType
            if (!$flightCriteriaTypeIATA_AircraftTypeItem instanceof \StructType\IATA_AircraftTypeType) {
                $invalidValues[] = is_object($flightCriteriaTypeIATA_AircraftTypeItem) ? get_class($flightCriteriaTypeIATA_AircraftTypeItem) : sprintf('%s(%s)', gettype($flightCriteriaTypeIATA_AircraftTypeItem), var_export($flightCriteriaTypeIATA_AircraftTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IATA_AircraftType property can only contain items of type \StructType\IATA_AircraftTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IATA_AircraftType value
     * @throws \InvalidArgumentException
     * @param \StructType\IATA_AircraftTypeType[] $iATA_AircraftType
     * @return \StructType\FlightCriteriaType
     */
    public function setIATA_AircraftType(array $iATA_AircraftType = array())
    {
        // validation for constraint: array
        if ('' !== ($iATA_AircraftTypeArrayErrorMessage = self::validateIATA_AircraftTypeForArrayConstraintsFromSetIATA_AircraftType($iATA_AircraftType))) {
            throw new \InvalidArgumentException($iATA_AircraftTypeArrayErrorMessage, __LINE__);
        }
        $this->IATA_AircraftType = $iATA_AircraftType;
        return $this;
    }
    /**
     * Add item to IATA_AircraftType value
     * @throws \InvalidArgumentException
     * @param \StructType\IATA_AircraftTypeType $item
     * @return \StructType\FlightCriteriaType
     */
    public function addToIATA_AircraftType(\StructType\IATA_AircraftTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IATA_AircraftTypeType) {
            throw new \InvalidArgumentException(sprintf('The IATA_AircraftType property can only contain items of type \StructType\IATA_AircraftTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IATA_AircraftType[] = $item;
        return $this;
    }
    /**
     * Get RBD value
     * @return \StructType\RBD_Type[]|null
     */
    public function getRBD()
    {
        return $this->RBD;
    }
    /**
     * This method is responsible for validating the values passed to the setRBD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRBD method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRBDForArrayConstraintsFromSetRBD(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightCriteriaTypeRBDItem) {
            // validation for constraint: itemType
            if (!$flightCriteriaTypeRBDItem instanceof \StructType\RBD_Type) {
                $invalidValues[] = is_object($flightCriteriaTypeRBDItem) ? get_class($flightCriteriaTypeRBDItem) : sprintf('%s(%s)', gettype($flightCriteriaTypeRBDItem), var_export($flightCriteriaTypeRBDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RBD property can only contain items of type \StructType\RBD_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RBD value
     * @throws \InvalidArgumentException
     * @param \StructType\RBD_Type[] $rBD
     * @return \StructType\FlightCriteriaType
     */
    public function setRBD(array $rBD = array())
    {
        // validation for constraint: array
        if ('' !== ($rBDArrayErrorMessage = self::validateRBDForArrayConstraintsFromSetRBD($rBD))) {
            throw new \InvalidArgumentException($rBDArrayErrorMessage, __LINE__);
        }
        $this->RBD = $rBD;
        return $this;
    }
    /**
     * Add item to RBD value
     * @throws \InvalidArgumentException
     * @param \StructType\RBD_Type $item
     * @return \StructType\FlightCriteriaType
     */
    public function addToRBD(\StructType\RBD_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RBD_Type) {
            throw new \InvalidArgumentException(sprintf('The RBD property can only contain items of type \StructType\RBD_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RBD[] = $item;
        return $this;
    }
}
