<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightCharacteristicsCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight characteristics filter criteria for shopping requests, including non-stop, red eye, etc.
 * @subpackage Structs
 */
class FlightCharacteristicsCriteriaType extends AbstractStructBase
{
    /**
     * The CharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Code to identify the type of flight characteristic (including non-stop, red eye, etc.) | Business data type for Flight Characteristics Code.
     * - base: FlightCharacteristicsCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CharacteristicCode;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for FlightCharacteristicsCriteriaType
     * @uses FlightCharacteristicsCriteriaType::setCharacteristicCode()
     * @uses FlightCharacteristicsCriteriaType::setPrefLevel()
     * @param string $characteristicCode
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct($characteristicCode = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setCharacteristicCode($characteristicCode)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get CharacteristicCode value
     * @return string
     */
    public function getCharacteristicCode()
    {
        return $this->CharacteristicCode;
    }
    /**
     * Set CharacteristicCode value
     * @param string $characteristicCode
     * @return \StructType\FlightCharacteristicsCriteriaType
     */
    public function setCharacteristicCode($characteristicCode = null)
    {
        // validation for constraint: string
        if (!is_null($characteristicCode) && !is_string($characteristicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characteristicCode, true), gettype($characteristicCode)), __LINE__);
        }
        $this->CharacteristicCode = $characteristicCode;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\FlightCharacteristicsCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
