<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterAirlineProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specialization of Airline Profile for use in request messages as a filter. Distribution profile of an airline which describes which types of shopping requests may be processed by a particular carrier.
 * @subpackage Structs
 */
class FilterAirlineProfileType extends AbstractStructBase
{
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The AirlineProfileURL
     * Meta information extracted from the WSDL
     * - documentation: Link to Airline Profile Source File. Alows a large Airline Profile file to be distributed over FTP, FTPS, as agreed bilaterally with Profile Owner. Note, this element should not be used if explicitly providing the Airline Profile
     * Data Items. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineProfileURL;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * Constructor method for FilterAirlineProfileType
     * @uses FilterAirlineProfileType::setOwnerCode()
     * @uses FilterAirlineProfileType::setAirlineProfileURL()
     * @uses FilterAirlineProfileType::setContactInfo()
     * @param string $ownerCode
     * @param string $airlineProfileURL
     * @param \StructType\ContactInfoType[] $contactInfo
     */
    public function __construct($ownerCode = null, $airlineProfileURL = null, array $contactInfo = array())
    {
        $this
            ->setOwnerCode($ownerCode)
            ->setAirlineProfileURL($airlineProfileURL)
            ->setContactInfo($contactInfo);
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\FilterAirlineProfileType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get AirlineProfileURL value
     * @return string|null
     */
    public function getAirlineProfileURL()
    {
        return $this->AirlineProfileURL;
    }
    /**
     * Set AirlineProfileURL value
     * @param string $airlineProfileURL
     * @return \StructType\FilterAirlineProfileType
     */
    public function setAirlineProfileURL($airlineProfileURL = null)
    {
        // validation for constraint: string
        if (!is_null($airlineProfileURL) && !is_string($airlineProfileURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineProfileURL, true), gettype($airlineProfileURL)), __LINE__);
        }
        $this->AirlineProfileURL = $airlineProfileURL;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $filterAirlineProfileTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$filterAirlineProfileTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($filterAirlineProfileTypeContactInfoItem) ? get_class($filterAirlineProfileTypeContactInfoItem) : sprintf('%s(%s)', gettype($filterAirlineProfileTypeContactInfoItem), var_export($filterAirlineProfileTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\FilterAirlineProfileType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\FilterAirlineProfileType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
}
