<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareWaiver StructType
 * Meta information extracted from the WSDL
 * - documentation: Validating carrier-assigned fare rule modification or override information.
 * @subpackage Structs
 */
class FareWaiver extends AbstractStructBase
{
    /**
     * The FareRuleWaiverCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by the validating carrier that allows fare rule modification or override.
     * @var string
     */
    public $FareRuleWaiverCode;
    /**
     * The FareWaiverTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Waiver type code. Examples: ExchangeReissued, FareComponent.
     * @var string
     */
    public $FareWaiverTypeCode;
    /**
     * Constructor method for FareWaiver
     * @uses FareWaiver::setFareRuleWaiverCode()
     * @uses FareWaiver::setFareWaiverTypeCode()
     * @param string $fareRuleWaiverCode
     * @param string $fareWaiverTypeCode
     */
    public function __construct($fareRuleWaiverCode = null, $fareWaiverTypeCode = null)
    {
        $this
            ->setFareRuleWaiverCode($fareRuleWaiverCode)
            ->setFareWaiverTypeCode($fareWaiverTypeCode);
    }
    /**
     * Get FareRuleWaiverCode value
     * @return string|null
     */
    public function getFareRuleWaiverCode()
    {
        return $this->FareRuleWaiverCode;
    }
    /**
     * Set FareRuleWaiverCode value
     * @param string $fareRuleWaiverCode
     * @return \StructType\FareWaiver
     */
    public function setFareRuleWaiverCode($fareRuleWaiverCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareRuleWaiverCode) && !is_string($fareRuleWaiverCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRuleWaiverCode, true), gettype($fareRuleWaiverCode)), __LINE__);
        }
        $this->FareRuleWaiverCode = $fareRuleWaiverCode;
        return $this;
    }
    /**
     * Get FareWaiverTypeCode value
     * @return string|null
     */
    public function getFareWaiverTypeCode()
    {
        return $this->FareWaiverTypeCode;
    }
    /**
     * Set FareWaiverTypeCode value
     * @param string $fareWaiverTypeCode
     * @return \StructType\FareWaiver
     */
    public function setFareWaiverTypeCode($fareWaiverTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareWaiverTypeCode) && !is_string($fareWaiverTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareWaiverTypeCode, true), gettype($fareWaiverTypeCode)), __LINE__);
        }
        $this->FareWaiverTypeCode = $fareWaiverTypeCode;
        return $this;
    }
}
