<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleTextType StructType
 * Meta information extracted from the WSDL
 * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
 * @subpackage Structs
 */
class FareRuleTextType extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: Fare category number as defined by ATPCO. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleCode;
    /**
     * Constructor method for FareRuleTextType
     * @uses FareRuleTextType::setRemark()
     * @uses FareRuleTextType::setRuleCode()
     * @param \StructType\RemarkType[] $remark
     * @param string $ruleCode
     */
    public function __construct(array $remark = array(), $ruleCode = null)
    {
        $this
            ->setRemark($remark)
            ->setRuleCode($ruleCode);
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareRuleTextTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$fareRuleTextTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($fareRuleTextTypeRemarkItem) ? get_class($fareRuleTextTypeRemarkItem) : sprintf('%s(%s)', gettype($fareRuleTextTypeRemarkItem), var_export($fareRuleTextTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\FareRuleTextType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\FareRuleTextType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get RuleCode value
     * @return string|null
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\FareRuleTextType
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
}
