<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleTextCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Special purchasing rules and restrictions used to differentiate fare levels from one another.
 * @subpackage Structs
 */
class FareRuleTextCriteriaType extends AbstractStructBase
{
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: Fare category number as defined by ATPCO. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleCode;
    /**
     * Constructor method for FareRuleTextCriteriaType
     * @uses FareRuleTextCriteriaType::setRuleCode()
     * @param string $ruleCode
     */
    public function __construct($ruleCode = null)
    {
        $this
            ->setRuleCode($ruleCode);
    }
    /**
     * Get RuleCode value
     * @return string|null
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\FareRuleTextCriteriaType
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
}
