<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FarePriceTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: An additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
 * @subpackage Structs
 */
class FarePriceTypeType extends AbstractStructBase
{
    /**
     * The FarePriceTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the fare price provided is a filed amount, net amount, or a sell amount. | A fare price type.
     * - base: FarePriceTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FarePriceTypeCode;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * Constructor method for FarePriceTypeType
     * @uses FarePriceTypeType::setFarePriceTypeCode()
     * @uses FarePriceTypeType::setPrice()
     * @param string $farePriceTypeCode
     * @param \StructType\PriceType $price
     */
    public function __construct($farePriceTypeCode = null, \StructType\PriceType $price = null)
    {
        $this
            ->setFarePriceTypeCode($farePriceTypeCode)
            ->setPrice($price);
    }
    /**
     * Get FarePriceTypeCode value
     * @return string
     */
    public function getFarePriceTypeCode()
    {
        return $this->FarePriceTypeCode;
    }
    /**
     * Set FarePriceTypeCode value
     * @param string $farePriceTypeCode
     * @return \StructType\FarePriceTypeType
     */
    public function setFarePriceTypeCode($farePriceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($farePriceTypeCode) && !is_string($farePriceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farePriceTypeCode, true), gettype($farePriceTypeCode)), __LINE__);
        }
        $this->FarePriceTypeCode = $farePriceTypeCode;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\FarePriceTypeType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
