<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Fare criteria used to filter shopping results.
 * @subpackage Structs
 */
class FareCriteriaType extends AbstractStructBase
{
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareBasisCode;
    /**
     * The FareSubTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A subdivision of a Fare Type as bilaterally agreed (for example a 'Humanitarian' Fare). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareSubTypeCode;
    /**
     * The FareTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Fare type. Examples: 70J-Published Fares, 749-Negotiated Fares, 756-One Way Fare, 758-Private Fares Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier | A code is a character string of letters, numbers, special characters
     * (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareTypeCode;
    /**
     * The GroupFareCriteria
     * Meta information extracted from the WSDL
     * - documentation: Group Fare preferences by passenger type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GroupFareCriteriaType[]
     */
    public $GroupFareCriteria;
    /**
     * The NoAdvancePurchaseInd
     * Meta information extracted from the WSDL
     * - documentation: When true, do not return fares with advance purchase restrictions. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NoAdvancePurchaseInd;
    /**
     * The NoPenaltyInd
     * Meta information extracted from the WSDL
     * - documentation: When true, do not return fares with penalties. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NoPenaltyInd;
    /**
     * Constructor method for FareCriteriaType
     * @uses FareCriteriaType::setPrefLevel()
     * @uses FareCriteriaType::setFareBasisCode()
     * @uses FareCriteriaType::setFareSubTypeCode()
     * @uses FareCriteriaType::setFareTypeCode()
     * @uses FareCriteriaType::setGroupFareCriteria()
     * @uses FareCriteriaType::setNoAdvancePurchaseInd()
     * @uses FareCriteriaType::setNoPenaltyInd()
     * @param \StructType\PrefLevelType $prefLevel
     * @param string[] $fareBasisCode
     * @param string[] $fareSubTypeCode
     * @param string[] $fareTypeCode
     * @param \StructType\GroupFareCriteriaType[] $groupFareCriteria
     * @param bool $noAdvancePurchaseInd
     * @param bool $noPenaltyInd
     */
    public function __construct(\StructType\PrefLevelType $prefLevel = null, array $fareBasisCode = array(), array $fareSubTypeCode = array(), array $fareTypeCode = array(), array $groupFareCriteria = array(), $noAdvancePurchaseInd = null, $noPenaltyInd = null)
    {
        $this
            ->setPrefLevel($prefLevel)
            ->setFareBasisCode($fareBasisCode)
            ->setFareSubTypeCode($fareSubTypeCode)
            ->setFareTypeCode($fareTypeCode)
            ->setGroupFareCriteria($groupFareCriteria)
            ->setNoAdvancePurchaseInd($noAdvancePurchaseInd)
            ->setNoPenaltyInd($noPenaltyInd);
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\FareCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareBasisCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareBasisCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareCriteriaTypeFareBasisCodeItem) {
            // validation for constraint: itemType
            if (!is_string($fareCriteriaTypeFareBasisCodeItem)) {
                $invalidValues[] = is_object($fareCriteriaTypeFareBasisCodeItem) ? get_class($fareCriteriaTypeFareBasisCodeItem) : sprintf('%s(%s)', gettype($fareCriteriaTypeFareBasisCodeItem), var_export($fareCriteriaTypeFareBasisCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareBasisCode
     * @return \StructType\FareCriteriaType
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareBasisCodeArrayErrorMessage = self::validateFareBasisCodeForArrayConstraintsFromSetFareBasisCode($fareBasisCode))) {
            throw new \InvalidArgumentException($fareBasisCodeArrayErrorMessage, __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FareCriteriaType
     */
    public function addToFareBasisCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Get FareSubTypeCode value
     * @return string[]|null
     */
    public function getFareSubTypeCode()
    {
        return $this->FareSubTypeCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareSubTypeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareSubTypeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareSubTypeCodeForArrayConstraintsFromSetFareSubTypeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareCriteriaTypeFareSubTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($fareCriteriaTypeFareSubTypeCodeItem)) {
                $invalidValues[] = is_object($fareCriteriaTypeFareSubTypeCodeItem) ? get_class($fareCriteriaTypeFareSubTypeCodeItem) : sprintf('%s(%s)', gettype($fareCriteriaTypeFareSubTypeCodeItem), var_export($fareCriteriaTypeFareSubTypeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareSubTypeCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareSubTypeCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareSubTypeCode
     * @return \StructType\FareCriteriaType
     */
    public function setFareSubTypeCode(array $fareSubTypeCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareSubTypeCodeArrayErrorMessage = self::validateFareSubTypeCodeForArrayConstraintsFromSetFareSubTypeCode($fareSubTypeCode))) {
            throw new \InvalidArgumentException($fareSubTypeCodeArrayErrorMessage, __LINE__);
        }
        $this->FareSubTypeCode = $fareSubTypeCode;
        return $this;
    }
    /**
     * Add item to FareSubTypeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FareCriteriaType
     */
    public function addToFareSubTypeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareSubTypeCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareSubTypeCode[] = $item;
        return $this;
    }
    /**
     * Get FareTypeCode value
     * @return string[]|null
     */
    public function getFareTypeCode()
    {
        return $this->FareTypeCode;
    }
    /**
     * This method is responsible for validating the values passed to the setFareTypeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareTypeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareTypeCodeForArrayConstraintsFromSetFareTypeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareCriteriaTypeFareTypeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($fareCriteriaTypeFareTypeCodeItem)) {
                $invalidValues[] = is_object($fareCriteriaTypeFareTypeCodeItem) ? get_class($fareCriteriaTypeFareTypeCodeItem) : sprintf('%s(%s)', gettype($fareCriteriaTypeFareTypeCodeItem), var_export($fareCriteriaTypeFareTypeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareTypeCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareTypeCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareTypeCode
     * @return \StructType\FareCriteriaType
     */
    public function setFareTypeCode(array $fareTypeCode = array())
    {
        // validation for constraint: array
        if ('' !== ($fareTypeCodeArrayErrorMessage = self::validateFareTypeCodeForArrayConstraintsFromSetFareTypeCode($fareTypeCode))) {
            throw new \InvalidArgumentException($fareTypeCodeArrayErrorMessage, __LINE__);
        }
        $this->FareTypeCode = $fareTypeCode;
        return $this;
    }
    /**
     * Add item to FareTypeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FareCriteriaType
     */
    public function addToFareTypeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareTypeCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareTypeCode[] = $item;
        return $this;
    }
    /**
     * Get GroupFareCriteria value
     * @return \StructType\GroupFareCriteriaType[]|null
     */
    public function getGroupFareCriteria()
    {
        return $this->GroupFareCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupFareCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupFareCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupFareCriteriaForArrayConstraintsFromSetGroupFareCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareCriteriaTypeGroupFareCriteriaItem) {
            // validation for constraint: itemType
            if (!$fareCriteriaTypeGroupFareCriteriaItem instanceof \StructType\GroupFareCriteriaType) {
                $invalidValues[] = is_object($fareCriteriaTypeGroupFareCriteriaItem) ? get_class($fareCriteriaTypeGroupFareCriteriaItem) : sprintf('%s(%s)', gettype($fareCriteriaTypeGroupFareCriteriaItem), var_export($fareCriteriaTypeGroupFareCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GroupFareCriteria property can only contain items of type \StructType\GroupFareCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupFareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupFareCriteriaType[] $groupFareCriteria
     * @return \StructType\FareCriteriaType
     */
    public function setGroupFareCriteria(array $groupFareCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($groupFareCriteriaArrayErrorMessage = self::validateGroupFareCriteriaForArrayConstraintsFromSetGroupFareCriteria($groupFareCriteria))) {
            throw new \InvalidArgumentException($groupFareCriteriaArrayErrorMessage, __LINE__);
        }
        $this->GroupFareCriteria = $groupFareCriteria;
        return $this;
    }
    /**
     * Add item to GroupFareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupFareCriteriaType $item
     * @return \StructType\FareCriteriaType
     */
    public function addToGroupFareCriteria(\StructType\GroupFareCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupFareCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The GroupFareCriteria property can only contain items of type \StructType\GroupFareCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GroupFareCriteria[] = $item;
        return $this;
    }
    /**
     * Get NoAdvancePurchaseInd value
     * @return bool|null
     */
    public function getNoAdvancePurchaseInd()
    {
        return $this->NoAdvancePurchaseInd;
    }
    /**
     * Set NoAdvancePurchaseInd value
     * @param bool $noAdvancePurchaseInd
     * @return \StructType\FareCriteriaType
     */
    public function setNoAdvancePurchaseInd($noAdvancePurchaseInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noAdvancePurchaseInd) && !is_bool($noAdvancePurchaseInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noAdvancePurchaseInd, true), gettype($noAdvancePurchaseInd)), __LINE__);
        }
        $this->NoAdvancePurchaseInd = $noAdvancePurchaseInd;
        return $this;
    }
    /**
     * Get NoPenaltyInd value
     * @return bool|null
     */
    public function getNoPenaltyInd()
    {
        return $this->NoPenaltyInd;
    }
    /**
     * Set NoPenaltyInd value
     * @param bool $noPenaltyInd
     * @return \StructType\FareCriteriaType
     */
    public function setNoPenaltyInd($noPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noPenaltyInd) && !is_bool($noPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noPenaltyInd, true), gettype($noPenaltyInd)), __LINE__);
        }
        $this->NoPenaltyInd = $noPenaltyInd;
        return $this;
    }
}
