<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareCalculationInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the calculation of the Fare amount by applying various rules to determine a final fare for an airline ticket.
 * @subpackage Structs
 */
class FareCalculationInfo extends AbstractStructBase
{
    /**
     * The AddlInfoText
     * Meta information extracted from the WSDL
     * - documentation: The fare calculation text required in the fare calculation area of an electronic ticket.
     * @var string
     */
    public $AddlInfoText;
    /**
     * The PricingCodeText
     * Meta information extracted from the WSDL
     * - documentation: Primary identifier reflecting the method of pricing for a transaction.
     * @var string
     */
    public $PricingCodeText;
    /**
     * The ReportingCodeText
     * Meta information extracted from the WSDL
     * - documentation: Secondary identifier reflecting the method of pricing for a transaction used in the reporting process.
     * - minOccurs: 0
     * @var string
     */
    public $ReportingCodeText;
    /**
     * Constructor method for FareCalculationInfo
     * @uses FareCalculationInfo::setAddlInfoText()
     * @uses FareCalculationInfo::setPricingCodeText()
     * @uses FareCalculationInfo::setReportingCodeText()
     * @param string $addlInfoText
     * @param string $pricingCodeText
     * @param string $reportingCodeText
     */
    public function __construct($addlInfoText = null, $pricingCodeText = null, $reportingCodeText = null)
    {
        $this
            ->setAddlInfoText($addlInfoText)
            ->setPricingCodeText($pricingCodeText)
            ->setReportingCodeText($reportingCodeText);
    }
    /**
     * Get AddlInfoText value
     * @return string|null
     */
    public function getAddlInfoText()
    {
        return $this->AddlInfoText;
    }
    /**
     * Set AddlInfoText value
     * @param string $addlInfoText
     * @return \StructType\FareCalculationInfo
     */
    public function setAddlInfoText($addlInfoText = null)
    {
        // validation for constraint: string
        if (!is_null($addlInfoText) && !is_string($addlInfoText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addlInfoText, true), gettype($addlInfoText)), __LINE__);
        }
        $this->AddlInfoText = $addlInfoText;
        return $this;
    }
    /**
     * Get PricingCodeText value
     * @return string|null
     */
    public function getPricingCodeText()
    {
        return $this->PricingCodeText;
    }
    /**
     * Set PricingCodeText value
     * @param string $pricingCodeText
     * @return \StructType\FareCalculationInfo
     */
    public function setPricingCodeText($pricingCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($pricingCodeText) && !is_string($pricingCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingCodeText, true), gettype($pricingCodeText)), __LINE__);
        }
        $this->PricingCodeText = $pricingCodeText;
        return $this;
    }
    /**
     * Get ReportingCodeText value
     * @return string|null
     */
    public function getReportingCodeText()
    {
        return $this->ReportingCodeText;
    }
    /**
     * Set ReportingCodeText value
     * @param string $reportingCodeText
     * @return \StructType\FareCalculationInfo
     */
    public function setReportingCodeText($reportingCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($reportingCodeText) && !is_string($reportingCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingCodeText, true), gettype($reportingCodeText)), __LINE__);
        }
        $this->ReportingCodeText = $reportingCodeText;
        return $this;
    }
}
