<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information returned by an Auto-Exchange application (e.g. ITA Reshop)
 * @subpackage Structs
 */
class ExchangeInfo extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Penalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Penalty
     */
    public $Penalty;
    /**
     * The CommPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommPenalty
     */
    public $CommPenalty;
    /**
     * The ValueOfOldTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValueOfOldTicket
     */
    public $ValueOfOldTicket;
    /**
     * Constructor method for ExchangeInfo
     * @uses ExchangeInfo::setCurrencyCode()
     * @uses ExchangeInfo::setPenalty()
     * @uses ExchangeInfo::setCommPenalty()
     * @uses ExchangeInfo::setValueOfOldTicket()
     * @param string $currencyCode
     * @param \StructType\Penalty $penalty
     * @param \StructType\CommPenalty $commPenalty
     * @param \StructType\ValueOfOldTicket $valueOfOldTicket
     */
    public function __construct($currencyCode = null, \StructType\Penalty $penalty = null, \StructType\CommPenalty $commPenalty = null, \StructType\ValueOfOldTicket $valueOfOldTicket = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setPenalty($penalty)
            ->setCommPenalty($commPenalty)
            ->setValueOfOldTicket($valueOfOldTicket);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ExchangeInfo
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Penalty value
     * @return \StructType\Penalty|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @param \StructType\Penalty $penalty
     * @return \StructType\ExchangeInfo
     */
    public function setPenalty(\StructType\Penalty $penalty = null)
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Get CommPenalty value
     * @return \StructType\CommPenalty|null
     */
    public function getCommPenalty()
    {
        return $this->CommPenalty;
    }
    /**
     * Set CommPenalty value
     * @param \StructType\CommPenalty $commPenalty
     * @return \StructType\ExchangeInfo
     */
    public function setCommPenalty(\StructType\CommPenalty $commPenalty = null)
    {
        $this->CommPenalty = $commPenalty;
        return $this;
    }
    /**
     * Get ValueOfOldTicket value
     * @return \StructType\ValueOfOldTicket|null
     */
    public function getValueOfOldTicket()
    {
        return $this->ValueOfOldTicket;
    }
    /**
     * Set ValueOfOldTicket value
     * @param \StructType\ValueOfOldTicket $valueOfOldTicket
     * @return \StructType\ExchangeInfo
     */
    public function setValueOfOldTicket(\StructType\ValueOfOldTicket $valueOfOldTicket = null)
    {
        $this->ValueOfOldTicket = $valueOfOldTicket;
        return $this;
    }
}
