<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcessBaggageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Excess baggage information displayed on a coupon.
 * @subpackage Structs
 */
class ExcessBaggageType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Excess baggage amount. Example: 100 USD.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The ExcessBaggageMeasure
     * Meta information extracted from the WSDL
     * - documentation: Excess baggage measure and associated Unit of Measurement (e.g. 10 kg).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MeasureType
     */
    public $ExcessBaggageMeasure;
    /**
     * Constructor method for ExcessBaggageType
     * @uses ExcessBaggageType::setAmount()
     * @uses ExcessBaggageType::setExcessBaggageMeasure()
     * @param \StructType\AmountType $amount
     * @param \StructType\MeasureType $excessBaggageMeasure
     */
    public function __construct(\StructType\AmountType $amount = null, \StructType\MeasureType $excessBaggageMeasure = null)
    {
        $this
            ->setAmount($amount)
            ->setExcessBaggageMeasure($excessBaggageMeasure);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\ExcessBaggageType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ExcessBaggageMeasure value
     * @return \StructType\MeasureType
     */
    public function getExcessBaggageMeasure()
    {
        return $this->ExcessBaggageMeasure;
    }
    /**
     * Set ExcessBaggageMeasure value
     * @param \StructType\MeasureType $excessBaggageMeasure
     * @return \StructType\ExcessBaggageType
     */
    public function setExcessBaggageMeasure(\StructType\MeasureType $excessBaggageMeasure = null)
    {
        $this->ExcessBaggageMeasure = $excessBaggageMeasure;
        return $this;
    }
}
