<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquivID StructType
 * Meta information extracted from the WSDL
 * - documentation: Equivalent Identifier detail.
 * @subpackage Structs
 */
class EquivID extends AbstractStructBase
{
    /**
     * The EquivalentID_Key
     * Meta information extracted from the WSDL
     * - ref: EquivalentID_Key
     * @var string
     */
    public $EquivalentID_Key;
    /**
     * The ID_Value
     * Meta information extracted from the WSDL
     * - documentation: Equivalent ID value. Example: MYSRVC123 | A data type for a Unique String Identifier constraint.
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $ID_Value;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - documentation: Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes. Example: UA, BAEncoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code | A data type for
     * Proper Name size constraint.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $Owner;
    /**
     * Constructor method for EquivID
     * @uses EquivID::setEquivalentID_Key()
     * @uses EquivID::setID_Value()
     * @uses EquivID::setOwner()
     * @param string $equivalentID_Key
     * @param string $iD_Value
     * @param string $owner
     */
    public function __construct($equivalentID_Key = null, $iD_Value = null, $owner = null)
    {
        $this
            ->setEquivalentID_Key($equivalentID_Key)
            ->setID_Value($iD_Value)
            ->setOwner($owner);
    }
    /**
     * Get EquivalentID_Key value
     * @return string|null
     */
    public function getEquivalentID_Key()
    {
        return $this->EquivalentID_Key;
    }
    /**
     * Set EquivalentID_Key value
     * @param string $equivalentID_Key
     * @return \StructType\EquivID
     */
    public function setEquivalentID_Key($equivalentID_Key = null)
    {
        // validation for constraint: string
        if (!is_null($equivalentID_Key) && !is_string($equivalentID_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equivalentID_Key, true), gettype($equivalentID_Key)), __LINE__);
        }
        $this->EquivalentID_Key = $equivalentID_Key;
        return $this;
    }
    /**
     * Get ID_Value value
     * @return string|null
     */
    public function getID_Value()
    {
        return $this->ID_Value;
    }
    /**
     * Set ID_Value value
     * @param string $iD_Value
     * @return \StructType\EquivID
     */
    public function setID_Value($iD_Value = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Value) && !is_string($iD_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD_Value, true), gettype($iD_Value)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD_Value) && mb_strlen($iD_Value) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD_Value)), __LINE__);
        }
        $this->ID_Value = $iD_Value;
        return $this;
    }
    /**
     * Get Owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param string $owner
     * @return \StructType\EquivID
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($owner) && mb_strlen($owner) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($owner)), __LINE__);
        }
        $this->Owner = $owner;
        return $this;
    }
}
