<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipment StructType
 * Meta information extracted from the WSDL
 * - documentation: Equipment group
 * @subpackage Structs
 */
class Equipment extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - ref: Code
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - ref: Name
     * @var string
     */
    public $Name;
    /**
     * The AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Airline specific aircraft equipment type code.Example: 747
     * @var string
     */
    public $AircraftType;
    /**
     * Constructor method for Equipment
     * @uses Equipment::setCode()
     * @uses Equipment::setName()
     * @uses Equipment::setAircraftType()
     * @param string $code
     * @param string $name
     * @param string $aircraftType
     */
    public function __construct($code = null, $name = null, $aircraftType = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setAircraftType($aircraftType);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Equipment
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Equipment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AircraftType value
     * @return string|null
     */
    public function getAircraftType()
    {
        return $this->AircraftType;
    }
    /**
     * Set AircraftType value
     * @param string $aircraftType
     * @return \StructType\Equipment
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftType, true), gettype($aircraftType)), __LINE__);
        }
        $this->AircraftType = $aircraftType;
        return $this;
    }
}
