<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EligibilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Refers to the Passengers, Price class or segments for which this offer item is eligible.
 * @subpackage Structs
 */
class EligibilityType extends AbstractStructBase
{
    /**
     * The OfferFlightAssociations
     * Meta information extracted from the WSDL
     * - documentation: Offer Flight Associations
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferFlightAssociationsType
     */
    public $OfferFlightAssociations;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the passengers who are elibigle for this Offer Item | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PriceClassRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Price Class for which this Offer Item can be provided. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PriceClassRefID;
    /**
     * Constructor method for EligibilityType
     * @uses EligibilityType::setOfferFlightAssociations()
     * @uses EligibilityType::setPaxRefID()
     * @uses EligibilityType::setPriceClassRefID()
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     * @param string[] $paxRefID
     * @param string[] $priceClassRefID
     */
    public function __construct(\StructType\OfferFlightAssociationsType $offerFlightAssociations = null, array $paxRefID = array(), array $priceClassRefID = array())
    {
        $this
            ->setOfferFlightAssociations($offerFlightAssociations)
            ->setPaxRefID($paxRefID)
            ->setPriceClassRefID($priceClassRefID);
    }
    /**
     * Get OfferFlightAssociations value
     * @return \StructType\OfferFlightAssociationsType|null
     */
    public function getOfferFlightAssociations()
    {
        return $this->OfferFlightAssociations;
    }
    /**
     * Set OfferFlightAssociations value
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     * @return \StructType\EligibilityType
     */
    public function setOfferFlightAssociations(\StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this->OfferFlightAssociations = $offerFlightAssociations;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eligibilityTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($eligibilityTypePaxRefIDItem)) {
                $invalidValues[] = is_object($eligibilityTypePaxRefIDItem) ? get_class($eligibilityTypePaxRefIDItem) : sprintf('%s(%s)', gettype($eligibilityTypePaxRefIDItem), var_export($eligibilityTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\EligibilityType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EligibilityType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PriceClassRefID value
     * @return string[]|null
     */
    public function getPriceClassRefID()
    {
        return $this->PriceClassRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceClassRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceClassRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceClassRefIDForArrayConstraintsFromSetPriceClassRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eligibilityTypePriceClassRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($eligibilityTypePriceClassRefIDItem)) {
                $invalidValues[] = is_object($eligibilityTypePriceClassRefIDItem) ? get_class($eligibilityTypePriceClassRefIDItem) : sprintf('%s(%s)', gettype($eligibilityTypePriceClassRefIDItem), var_export($eligibilityTypePriceClassRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceClassRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceClassRefID value
     * @throws \InvalidArgumentException
     * @param string[] $priceClassRefID
     * @return \StructType\EligibilityType
     */
    public function setPriceClassRefID(array $priceClassRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($priceClassRefIDArrayErrorMessage = self::validatePriceClassRefIDForArrayConstraintsFromSetPriceClassRefID($priceClassRefID))) {
            throw new \InvalidArgumentException($priceClassRefIDArrayErrorMessage, __LINE__);
        }
        $this->PriceClassRefID = $priceClassRefID;
        return $this;
    }
    /**
     * Add item to PriceClassRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EligibilityType
     */
    public function addToPriceClassRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PriceClassRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceClassRefID[] = $item;
        return $this;
    }
}
