<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectionalIndType StructType
 * Meta information extracted from the WSDL
 * - documentation: Directional Indicator container
 * @subpackage Structs
 */
class DirectionalIndType extends AbstractStructBase
{
    /**
     * The DirectionalIndText
     * Meta information extracted from the WSDL
     * - documentation: 1 = From LOC 1 to LOC 2 2 = To LOC 1 from LOC 2 3 = Both | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectionalIndText;
    /**
     * Constructor method for DirectionalIndType
     * @uses DirectionalIndType::setDirectionalIndText()
     * @param string $directionalIndText
     */
    public function __construct($directionalIndText = null)
    {
        $this
            ->setDirectionalIndText($directionalIndText);
    }
    /**
     * Get DirectionalIndText value
     * @return string|null
     */
    public function getDirectionalIndText()
    {
        return $this->DirectionalIndText;
    }
    /**
     * Set DirectionalIndText value
     * @param string $directionalIndText
     * @return \StructType\DirectionalIndType
     */
    public function setDirectionalIndText($directionalIndText = null)
    {
        // validation for constraint: string
        if (!is_null($directionalIndText) && !is_string($directionalIndText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directionalIndText, true), gettype($directionalIndText)), __LINE__);
        }
        $this->DirectionalIndText = $directionalIndText;
        return $this;
    }
}
