<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectBillType StructType
 * Meta information extracted from the WSDL
 * - documentation: System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
 * @subpackage Structs
 */
class DirectBillType extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactInfoType
     */
    public $ContactInfo;
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - documentation: The company ID of the corporation to whom remittance should be directed. Example: IBM | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgID;
    /**
     * The OrgName
     * Meta information extracted from the WSDL
     * - documentation: The company name of the corporation to whom remittance should be directed. Example: IBM | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgName;
    /**
     * Constructor method for DirectBillType
     * @uses DirectBillType::setContactInfo()
     * @uses DirectBillType::setOrgID()
     * @uses DirectBillType::setOrgName()
     * @param \StructType\ContactInfoType $contactInfo
     * @param string $orgID
     * @param string $orgName
     */
    public function __construct(\StructType\ContactInfoType $contactInfo = null, $orgID = null, $orgName = null)
    {
        $this
            ->setContactInfo($contactInfo)
            ->setOrgID($orgID)
            ->setOrgName($orgName);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\ContactInfoType $contactInfo
     * @return \StructType\DirectBillType
     */
    public function setContactInfo(\StructType\ContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get OrgID value
     * @return string|null
     */
    public function getOrgID()
    {
        return $this->OrgID;
    }
    /**
     * Set OrgID value
     * @param string $orgID
     * @return \StructType\DirectBillType
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        $this->OrgID = $orgID;
        return $this;
    }
    /**
     * Get OrgName value
     * @return string|null
     */
    public function getOrgName()
    {
        return $this->OrgName;
    }
    /**
     * Set OrgName value
     * @param string $orgName
     * @return \StructType\DirectBillType
     */
    public function setOrgName($orgName = null)
    {
        // validation for constraint: string
        if (!is_null($orgName) && !is_string($orgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgName, true), gettype($orgName)), __LINE__);
        }
        $this->OrgName = $orgName;
        return $this;
    }
}
