<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DifferentialPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
 * @subpackage Structs
 */
class DifferentialPriceType extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Base Fare Amount. Example: 200000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $BaseAmount;
    /**
     * The BaseAmountGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the Base Amount of an offer item is guaranteed. In the absence of the Base Amount guarantee time limit, the Base Amount is not guaranteed. Upon expiry, the Base Amount may no longer be guaranteed and either a new
     * shopping process should begin, or the offer should be repriced resulting in a new Offer. Should the Base Amount guarantee time limit extend beyond Order creation, the remaining length of time persists into the corresponding Order Item. The airline
     * can increase the remaining length of time beyond the original time limit should they wish to. This field should only be used when the Airline indicates that a Price Guarantee is available.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseAmountGuaranteeTimeLimitDateTime;
    /**
     * The CurConversion
     * Meta information extracted from the WSDL
     * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurConversionType[]
     */
    public $CurConversion;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - documentation: Deduction from the price amount, made in advance of its payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Discount
     */
    public $Discount;
    /**
     * The DueByAirlineAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $DueByAirlineAmount;
    /**
     * The DueToAirlineAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $DueToAirlineAmount;
    /**
     * The EquivAmount
     * Meta information extracted from the WSDL
     * - documentation: The entire amount of transaction stated in the local currency at the point of sale, or the currency as defined by the Currency Indicator Code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $EquivAmount;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Fee[]
     */
    public $Fee;
    /**
     * The LoyaltyUnitAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount specified in loyalty units. Note: the 'Currency Code' sup for this BDT should not be populated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $LoyaltyUnitAmount;
    /**
     * The LoyaltyUnitName
     * Meta information extracted from the WSDL
     * - documentation: The name of the loyalty unit used by the loyalty unit amount (e.g. miles or points). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyUnitName;
    /**
     * The Markup
     * Meta information extracted from the WSDL
     * - documentation: Defines the reason for the markup added by an airline as part of the offer reported as calculation detail. The amount added to the cost price of goods to cover overhead and profit. [Oxford]
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Markup[]
     */
    public $Markup;
    /**
     * The MaskedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to advise the Seller if the price will be masked to the Customer | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MaskedInd;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a usual charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Surcharge[]
     */
    public $Surcharge;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * Constructor method for DifferentialPriceType
     * @uses DifferentialPriceType::setBaseAmount()
     * @uses DifferentialPriceType::setBaseAmountGuaranteeTimeLimitDateTime()
     * @uses DifferentialPriceType::setCurConversion()
     * @uses DifferentialPriceType::setDiscount()
     * @uses DifferentialPriceType::setDueByAirlineAmount()
     * @uses DifferentialPriceType::setDueToAirlineAmount()
     * @uses DifferentialPriceType::setEquivAmount()
     * @uses DifferentialPriceType::setFee()
     * @uses DifferentialPriceType::setLoyaltyUnitAmount()
     * @uses DifferentialPriceType::setLoyaltyUnitName()
     * @uses DifferentialPriceType::setMarkup()
     * @uses DifferentialPriceType::setMaskedInd()
     * @uses DifferentialPriceType::setSurcharge()
     * @uses DifferentialPriceType::setTaxSummary()
     * @uses DifferentialPriceType::setTotalAmount()
     * @param \StructType\AmountType $baseAmount
     * @param string $baseAmountGuaranteeTimeLimitDateTime
     * @param \StructType\CurConversionType[] $curConversion
     * @param \StructType\Discount $discount
     * @param \StructType\AmountType $dueByAirlineAmount
     * @param \StructType\AmountType $dueToAirlineAmount
     * @param \StructType\AmountType $equivAmount
     * @param \StructType\Fee[] $fee
     * @param \StructType\AmountType $loyaltyUnitAmount
     * @param string $loyaltyUnitName
     * @param \StructType\Markup[] $markup
     * @param bool $maskedInd
     * @param \StructType\Surcharge[] $surcharge
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @param \StructType\AmountType $totalAmount
     */
    public function __construct(\StructType\AmountType $baseAmount = null, $baseAmountGuaranteeTimeLimitDateTime = null, array $curConversion = array(), \StructType\Discount $discount = null, \StructType\AmountType $dueByAirlineAmount = null, \StructType\AmountType $dueToAirlineAmount = null, \StructType\AmountType $equivAmount = null, array $fee = array(), \StructType\AmountType $loyaltyUnitAmount = null, $loyaltyUnitName = null, array $markup = array(), $maskedInd = null, array $surcharge = array(), array $taxSummary = array(), \StructType\AmountType $totalAmount = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setBaseAmountGuaranteeTimeLimitDateTime($baseAmountGuaranteeTimeLimitDateTime)
            ->setCurConversion($curConversion)
            ->setDiscount($discount)
            ->setDueByAirlineAmount($dueByAirlineAmount)
            ->setDueToAirlineAmount($dueToAirlineAmount)
            ->setEquivAmount($equivAmount)
            ->setFee($fee)
            ->setLoyaltyUnitAmount($loyaltyUnitAmount)
            ->setLoyaltyUnitName($loyaltyUnitName)
            ->setMarkup($markup)
            ->setMaskedInd($maskedInd)
            ->setSurcharge($surcharge)
            ->setTaxSummary($taxSummary)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get BaseAmount value
     * @return \StructType\AmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \StructType\AmountType $baseAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setBaseAmount(\StructType\AmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get BaseAmountGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getBaseAmountGuaranteeTimeLimitDateTime()
    {
        return $this->BaseAmountGuaranteeTimeLimitDateTime;
    }
    /**
     * Set BaseAmountGuaranteeTimeLimitDateTime value
     * @param string $baseAmountGuaranteeTimeLimitDateTime
     * @return \StructType\DifferentialPriceType
     */
    public function setBaseAmountGuaranteeTimeLimitDateTime($baseAmountGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($baseAmountGuaranteeTimeLimitDateTime) && !is_string($baseAmountGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseAmountGuaranteeTimeLimitDateTime, true), gettype($baseAmountGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->BaseAmountGuaranteeTimeLimitDateTime = $baseAmountGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get CurConversion value
     * @return \StructType\CurConversionType[]|null
     */
    public function getCurConversion()
    {
        return $this->CurConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurConversionForArrayConstraintsFromSetCurConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialPriceTypeCurConversionItem) {
            // validation for constraint: itemType
            if (!$differentialPriceTypeCurConversionItem instanceof \StructType\CurConversionType) {
                $invalidValues[] = is_object($differentialPriceTypeCurConversionItem) ? get_class($differentialPriceTypeCurConversionItem) : sprintf('%s(%s)', gettype($differentialPriceTypeCurConversionItem), var_export($differentialPriceTypeCurConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType[] $curConversion
     * @return \StructType\DifferentialPriceType
     */
    public function setCurConversion(array $curConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($curConversionArrayErrorMessage = self::validateCurConversionForArrayConstraintsFromSetCurConversion($curConversion))) {
            throw new \InvalidArgumentException($curConversionArrayErrorMessage, __LINE__);
        }
        $this->CurConversion = $curConversion;
        return $this;
    }
    /**
     * Add item to CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType $item
     * @return \StructType\DifferentialPriceType
     */
    public function addToCurConversion(\StructType\CurConversionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurConversionType) {
            throw new \InvalidArgumentException(sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurConversion[] = $item;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\Discount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\Discount $discount
     * @return \StructType\DifferentialPriceType
     */
    public function setDiscount(\StructType\Discount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get DueByAirlineAmount value
     * @return \StructType\AmountType|null
     */
    public function getDueByAirlineAmount()
    {
        return $this->DueByAirlineAmount;
    }
    /**
     * Set DueByAirlineAmount value
     * @param \StructType\AmountType $dueByAirlineAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setDueByAirlineAmount(\StructType\AmountType $dueByAirlineAmount = null)
    {
        $this->DueByAirlineAmount = $dueByAirlineAmount;
        return $this;
    }
    /**
     * Get DueToAirlineAmount value
     * @return \StructType\AmountType|null
     */
    public function getDueToAirlineAmount()
    {
        return $this->DueToAirlineAmount;
    }
    /**
     * Set DueToAirlineAmount value
     * @param \StructType\AmountType $dueToAirlineAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setDueToAirlineAmount(\StructType\AmountType $dueToAirlineAmount = null)
    {
        $this->DueToAirlineAmount = $dueToAirlineAmount;
        return $this;
    }
    /**
     * Get EquivAmount value
     * @return \StructType\AmountType|null
     */
    public function getEquivAmount()
    {
        return $this->EquivAmount;
    }
    /**
     * Set EquivAmount value
     * @param \StructType\AmountType $equivAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setEquivAmount(\StructType\AmountType $equivAmount = null)
    {
        $this->EquivAmount = $equivAmount;
        return $this;
    }
    /**
     * Get Fee value
     * @return \StructType\Fee[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialPriceTypeFeeItem) {
            // validation for constraint: itemType
            if (!$differentialPriceTypeFeeItem instanceof \StructType\Fee) {
                $invalidValues[] = is_object($differentialPriceTypeFeeItem) ? get_class($differentialPriceTypeFeeItem) : sprintf('%s(%s)', gettype($differentialPriceTypeFeeItem), var_export($differentialPriceTypeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee[] $fee
     * @return \StructType\DifferentialPriceType
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee $item
     * @return \StructType\DifferentialPriceType
     */
    public function addToFee(\StructType\Fee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fee) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyUnitAmount value
     * @return \StructType\AmountType|null
     */
    public function getLoyaltyUnitAmount()
    {
        return $this->LoyaltyUnitAmount;
    }
    /**
     * Set LoyaltyUnitAmount value
     * @param \StructType\AmountType $loyaltyUnitAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setLoyaltyUnitAmount(\StructType\AmountType $loyaltyUnitAmount = null)
    {
        $this->LoyaltyUnitAmount = $loyaltyUnitAmount;
        return $this;
    }
    /**
     * Get LoyaltyUnitName value
     * @return string|null
     */
    public function getLoyaltyUnitName()
    {
        return $this->LoyaltyUnitName;
    }
    /**
     * Set LoyaltyUnitName value
     * @param string $loyaltyUnitName
     * @return \StructType\DifferentialPriceType
     */
    public function setLoyaltyUnitName($loyaltyUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyUnitName) && !is_string($loyaltyUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyUnitName, true), gettype($loyaltyUnitName)), __LINE__);
        }
        $this->LoyaltyUnitName = $loyaltyUnitName;
        return $this;
    }
    /**
     * Get Markup value
     * @return \StructType\Markup[]|null
     */
    public function getMarkup()
    {
        return $this->Markup;
    }
    /**
     * This method is responsible for validating the values passed to the setMarkup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarkup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarkupForArrayConstraintsFromSetMarkup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialPriceTypeMarkupItem) {
            // validation for constraint: itemType
            if (!$differentialPriceTypeMarkupItem instanceof \StructType\Markup) {
                $invalidValues[] = is_object($differentialPriceTypeMarkupItem) ? get_class($differentialPriceTypeMarkupItem) : sprintf('%s(%s)', gettype($differentialPriceTypeMarkupItem), var_export($differentialPriceTypeMarkupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Markup property can only contain items of type \StructType\Markup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Markup value
     * @throws \InvalidArgumentException
     * @param \StructType\Markup[] $markup
     * @return \StructType\DifferentialPriceType
     */
    public function setMarkup(array $markup = array())
    {
        // validation for constraint: array
        if ('' !== ($markupArrayErrorMessage = self::validateMarkupForArrayConstraintsFromSetMarkup($markup))) {
            throw new \InvalidArgumentException($markupArrayErrorMessage, __LINE__);
        }
        $this->Markup = $markup;
        return $this;
    }
    /**
     * Add item to Markup value
     * @throws \InvalidArgumentException
     * @param \StructType\Markup $item
     * @return \StructType\DifferentialPriceType
     */
    public function addToMarkup(\StructType\Markup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Markup) {
            throw new \InvalidArgumentException(sprintf('The Markup property can only contain items of type \StructType\Markup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Markup[] = $item;
        return $this;
    }
    /**
     * Get MaskedInd value
     * @return bool|null
     */
    public function getMaskedInd()
    {
        return $this->MaskedInd;
    }
    /**
     * Set MaskedInd value
     * @param bool $maskedInd
     * @return \StructType\DifferentialPriceType
     */
    public function setMaskedInd($maskedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maskedInd) && !is_bool($maskedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maskedInd, true), gettype($maskedInd)), __LINE__);
        }
        $this->MaskedInd = $maskedInd;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return \StructType\Surcharge[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialPriceTypeSurchargeItem) {
            // validation for constraint: itemType
            if (!$differentialPriceTypeSurchargeItem instanceof \StructType\Surcharge) {
                $invalidValues[] = is_object($differentialPriceTypeSurchargeItem) ? get_class($differentialPriceTypeSurchargeItem) : sprintf('%s(%s)', gettype($differentialPriceTypeSurchargeItem), var_export($differentialPriceTypeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge[] $surcharge
     * @return \StructType\DifferentialPriceType
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge $item
     * @return \StructType\DifferentialPriceType
     */
    public function addToSurcharge(\StructType\Surcharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Surcharge) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSummaryForArrayConstraintsFromSetTaxSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialPriceTypeTaxSummaryItem) {
            // validation for constraint: itemType
            if (!$differentialPriceTypeTaxSummaryItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($differentialPriceTypeTaxSummaryItem) ? get_class($differentialPriceTypeTaxSummaryItem) : sprintf('%s(%s)', gettype($differentialPriceTypeTaxSummaryItem), var_export($differentialPriceTypeTaxSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @return \StructType\DifferentialPriceType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSummaryArrayErrorMessage = self::validateTaxSummaryForArrayConstraintsFromSetTaxSummary($taxSummary))) {
            throw new \InvalidArgumentException($taxSummaryArrayErrorMessage, __LINE__);
        }
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\DifferentialPriceType
     */
    public function addToTaxSummary(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\DifferentialPriceType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
