<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DifferentialFarePriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A differential specialization of an additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
 * @subpackage Structs
 */
class DifferentialFarePriceType extends AbstractStructBase
{
    /**
     * The DifferentialPrice
     * Meta information extracted from the WSDL
     * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
     * @var \StructType\DifferentialPriceType
     */
    public $DifferentialPrice;
    /**
     * The FarePriceTypeCode
     * @var string
     */
    public $FarePriceTypeCode;
    /**
     * Constructor method for DifferentialFarePriceType
     * @uses DifferentialFarePriceType::setDifferentialPrice()
     * @uses DifferentialFarePriceType::setFarePriceTypeCode()
     * @param \StructType\DifferentialPriceType $differentialPrice
     * @param string $farePriceTypeCode
     */
    public function __construct(\StructType\DifferentialPriceType $differentialPrice = null, $farePriceTypeCode = null)
    {
        $this
            ->setDifferentialPrice($differentialPrice)
            ->setFarePriceTypeCode($farePriceTypeCode);
    }
    /**
     * Get DifferentialPrice value
     * @return \StructType\DifferentialPriceType|null
     */
    public function getDifferentialPrice()
    {
        return $this->DifferentialPrice;
    }
    /**
     * Set DifferentialPrice value
     * @param \StructType\DifferentialPriceType $differentialPrice
     * @return \StructType\DifferentialFarePriceType
     */
    public function setDifferentialPrice(\StructType\DifferentialPriceType $differentialPrice = null)
    {
        $this->DifferentialPrice = $differentialPrice;
        return $this;
    }
    /**
     * Get FarePriceTypeCode value
     * @return string|null
     */
    public function getFarePriceTypeCode()
    {
        return $this->FarePriceTypeCode;
    }
    /**
     * Set FarePriceTypeCode value
     * @uses \EnumType\FarePriceTypeCode::valueIsValid()
     * @uses \EnumType\FarePriceTypeCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $farePriceTypeCode
     * @return \StructType\DifferentialFarePriceType
     */
    public function setFarePriceTypeCode($farePriceTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FarePriceTypeCode::valueIsValid($farePriceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FarePriceTypeCode', is_array($farePriceTypeCode) ? implode(', ', $farePriceTypeCode) : var_export($farePriceTypeCode, true), implode(', ', \EnumType\FarePriceTypeCode::getValidValues())), __LINE__);
        }
        $this->FarePriceTypeCode = $farePriceTypeCode;
        return $this;
    }
}
