<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Departure StructType
 * Meta information extracted from the WSDL
 * - documentation: IMPORTANT: Note that Date and Time elements are mandatory for regular flight sell. Only optional for OPEN segments. See also Flight/@Type=O attribute of the Flight element. | Flight departure group
 * @subpackage Structs
 */
class Departure extends AbstractStructBase
{
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: Airport code. Example: MIA
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - ref: AirportCode
     * @var string
     */
    public $AirportCode;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Date
     * @var string
     */
    public $Date;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - documentation: Time in ISO 8601 format (hh:mm). Example: 14:30 | Time in ISO 8601 twenty-four hour clock format. Example: 14:00
     * - base: xs:string
     * - length: 5
     * - minOccurs: 0
     * - pattern: ([0-1][0-9]|2[0-3]):[0-5][0-9]
     * - ref: Time
     * @var string
     */
    public $Time;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Terminal
     * @var string
     */
    public $Terminal;
    /**
     * The AirportName
     * Meta information extracted from the WSDL
     * - documentation: Airport Name. Example Miami International Airport
     * - minOccurs: 0
     * @var string
     */
    public $AirportName;
    /**
     * Constructor method for Departure
     * @uses Departure::setAirportCode()
     * @uses Departure::setDate()
     * @uses Departure::setTime()
     * @uses Departure::setTerminal()
     * @uses Departure::setAirportName()
     * @param string $airportCode
     * @param string $date
     * @param string $time
     * @param string $terminal
     * @param string $airportName
     */
    public function __construct($airportCode = null, $date = null, $time = null, $terminal = null, $airportName = null)
    {
        $this
            ->setAirportCode($airportCode)
            ->setDate($date)
            ->setTime($time)
            ->setTerminal($terminal)
            ->setAirportName($airportName);
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\Departure
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Departure
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\Departure
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($time) && mb_strlen($time) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($time)), __LINE__);
        }
        // validation for constraint: pattern(([0-1][0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($time) && !preg_match('/([0-1][0-9]|2[0-3]):[0-5][0-9]/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-1][0-9]|2[0-3]):[0-5][0-9]', var_export($time, true)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\Departure
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get AirportName value
     * @return string|null
     */
    public function getAirportName()
    {
        return $this->AirportName;
    }
    /**
     * Set AirportName value
     * @param string $airportName
     * @return \StructType\Departure
     */
    public function setAirportName($airportName = null)
    {
        // validation for constraint: string
        if (!is_null($airportName) && !is_string($airportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportName, true), gettype($airportName)), __LINE__);
        }
        $this->AirportName = $airportName;
        return $this;
    }
}
