<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveredOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Delivered Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
 * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
 * passenger in an Order may hold different sets of order items at different prices.
 * @subpackage Structs
 */
class DeliveredOrderType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - documentation: A Delivered Order individually priced item within a Delivered Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DeliveredOrderItemType[]
     */
    public $OrderItem;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is created. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $TotalPrice;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for DeliveredOrderType
     * @uses DeliveredOrderType::setOrderID()
     * @uses DeliveredOrderType::setOrderItem()
     * @uses DeliveredOrderType::setOwnerCode()
     * @uses DeliveredOrderType::setCommission()
     * @uses DeliveredOrderType::setCreationDateTime()
     * @uses DeliveredOrderType::setLastModifiedDateTime()
     * @uses DeliveredOrderType::setTotalPrice()
     * @uses DeliveredOrderType::setWebAddressURI()
     * @param string $orderID
     * @param \StructType\DeliveredOrderItemType[] $orderItem
     * @param string $ownerCode
     * @param \StructType\CommissionType[] $commission
     * @param string $creationDateTime
     * @param string $lastModifiedDateTime
     * @param \StructType\PriceType $totalPrice
     * @param string $webAddressURI
     */
    public function __construct($orderID = null, array $orderItem = array(), $ownerCode = null, array $commission = array(), $creationDateTime = null, $lastModifiedDateTime = null, \StructType\PriceType $totalPrice = null, $webAddressURI = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOrderItem($orderItem)
            ->setOwnerCode($ownerCode)
            ->setCommission($commission)
            ->setCreationDateTime($creationDateTime)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setTotalPrice($totalPrice)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\DeliveredOrderType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\DeliveredOrderItemType[]
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveredOrderTypeOrderItemItem) {
            // validation for constraint: itemType
            if (!$deliveredOrderTypeOrderItemItem instanceof \StructType\DeliveredOrderItemType) {
                $invalidValues[] = is_object($deliveredOrderTypeOrderItemItem) ? get_class($deliveredOrderTypeOrderItemItem) : sprintf('%s(%s)', gettype($deliveredOrderTypeOrderItemItem), var_export($deliveredOrderTypeOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItem property can only contain items of type \StructType\DeliveredOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderItemType[] $orderItem
     * @return \StructType\DeliveredOrderType
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderItemType $item
     * @return \StructType\DeliveredOrderType
     */
    public function addToOrderItem(\StructType\DeliveredOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveredOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of type \StructType\DeliveredOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\DeliveredOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveredOrderTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$deliveredOrderTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($deliveredOrderTypeCommissionItem) ? get_class($deliveredOrderTypeCommissionItem) : sprintf('%s(%s)', gettype($deliveredOrderTypeCommissionItem), var_export($deliveredOrderTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\DeliveredOrderType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\DeliveredOrderType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\DeliveredOrderType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\DeliveredOrderType
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDateTime, true), gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\PriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\PriceType $totalPrice
     * @return \StructType\DeliveredOrderType
     */
    public function setTotalPrice(\StructType\PriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\DeliveredOrderType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
