<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedOperatingSegmentListType StructType
 * Meta information extracted from the WSDL
 * - documentation: A list of dated operating segments used in the contained message.
 * @subpackage Structs
 */
class DatedOperatingSegmentListType extends AbstractStructBase
{
    /**
     * The DatedOperatingSegment
     * Meta information extracted from the WSDL
     * - documentation: An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DatedOperatingSegmentType[]
     */
    public $DatedOperatingSegment;
    /**
     * Constructor method for DatedOperatingSegmentListType
     * @uses DatedOperatingSegmentListType::setDatedOperatingSegment()
     * @param \StructType\DatedOperatingSegmentType[] $datedOperatingSegment
     */
    public function __construct(array $datedOperatingSegment = array())
    {
        $this
            ->setDatedOperatingSegment($datedOperatingSegment);
    }
    /**
     * Get DatedOperatingSegment value
     * @return \StructType\DatedOperatingSegmentType[]
     */
    public function getDatedOperatingSegment()
    {
        return $this->DatedOperatingSegment;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingSegmentForArrayConstraintsFromSetDatedOperatingSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingSegmentListTypeDatedOperatingSegmentItem) {
            // validation for constraint: itemType
            if (!$datedOperatingSegmentListTypeDatedOperatingSegmentItem instanceof \StructType\DatedOperatingSegmentType) {
                $invalidValues[] = is_object($datedOperatingSegmentListTypeDatedOperatingSegmentItem) ? get_class($datedOperatingSegmentListTypeDatedOperatingSegmentItem) : sprintf('%s(%s)', gettype($datedOperatingSegmentListTypeDatedOperatingSegmentItem), var_export($datedOperatingSegmentListTypeDatedOperatingSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingSegment property can only contain items of type \StructType\DatedOperatingSegmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentType[] $datedOperatingSegment
     * @return \StructType\DatedOperatingSegmentListType
     */
    public function setDatedOperatingSegment(array $datedOperatingSegment = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingSegmentArrayErrorMessage = self::validateDatedOperatingSegmentForArrayConstraintsFromSetDatedOperatingSegment($datedOperatingSegment))) {
            throw new \InvalidArgumentException($datedOperatingSegmentArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingSegment = $datedOperatingSegment;
        return $this;
    }
    /**
     * Add item to DatedOperatingSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentType $item
     * @return \StructType\DatedOperatingSegmentListType
     */
    public function addToDatedOperatingSegment(\StructType\DatedOperatingSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingSegmentType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingSegment property can only contain items of type \StructType\DatedOperatingSegmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingSegment[] = $item;
        return $this;
    }
}
