<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateRangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date range information for filter criteria.
 * @subpackage Structs
 */
class DateRangeType extends AbstractStructBase
{
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Effective (start) date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Expiration (end) date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * Constructor method for DateRangeType
     * @uses DateRangeType::setEffectiveDate()
     * @uses DateRangeType::setExpirationDate()
     * @param string $effectiveDate
     * @param string $expirationDate
     */
    public function __construct($effectiveDate = null, $expirationDate = null)
    {
        $this
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\DateRangeType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\DateRangeType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
}
