<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomParams StructType
 * Meta information extracted from the WSDL
 * - documentation: This data is only available on a bilateral basis. Please consult Farelogix or your airline to verify if the node is supported.
 * @subpackage Structs
 */
class CustomParams extends AbstractStructBase
{
    /**
     * The Param
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Param[]
     */
    public $Param;
    /**
     * Constructor method for CustomParams
     * @uses CustomParams::setParam()
     * @param \StructType\Param[] $param
     */
    public function __construct(array $param = array())
    {
        $this
            ->setParam($param);
    }
    /**
     * Get Param value
     * @return \StructType\Param[]|null
     */
    public function getParam()
    {
        return $this->Param;
    }
    /**
     * This method is responsible for validating the values passed to the setParam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamForArrayConstraintsFromSetParam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customParamsParamItem) {
            // validation for constraint: itemType
            if (!$customParamsParamItem instanceof \StructType\Param) {
                $invalidValues[] = is_object($customParamsParamItem) ? get_class($customParamsParamItem) : sprintf('%s(%s)', gettype($customParamsParamItem), var_export($customParamsParamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Param property can only contain items of type \StructType\Param, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Param value
     * @throws \InvalidArgumentException
     * @param \StructType\Param[] $param
     * @return \StructType\CustomParams
     */
    public function setParam(array $param = array())
    {
        // validation for constraint: array
        if ('' !== ($paramArrayErrorMessage = self::validateParamForArrayConstraintsFromSetParam($param))) {
            throw new \InvalidArgumentException($paramArrayErrorMessage, __LINE__);
        }
        $this->Param = $param;
        return $this;
    }
    /**
     * Add item to Param value
     * @throws \InvalidArgumentException
     * @param \StructType\Param $item
     * @return \StructType\CustomParams
     */
    public function addToParam(\StructType\Param $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Param) {
            throw new \InvalidArgumentException(sprintf('The Param property can only contain items of type \StructType\Param, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Param[] = $item;
        return $this;
    }
}
